<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['admin'])) header('Location: login.php');
$_SESSION['rol'] = 'superadmin';

// İSTATİSTİKLER - ŞİMDİ admin_gelir_gider TABLOSUNDAN ÇEKİYOR
$site_sayisi = $pdo->query("SELECT COUNT(*) FROM siteler")->fetchColumn();

$toplam_gelir = $pdo->query("SELECT COALESCE(SUM(tutar),0) FROM admin_gelir_gider WHERE tip='gelir'")->fetchColumn();
$toplam_gider = $pdo->query("SELECT COALESCE(SUM(tutar),0) FROM admin_gelir_gider WHERE tip='gider'")->fetchColumn();
$bakiye = $toplam_gelir - $toplam_gider;

// Son 10 site (değişmedi)
$son_siteler = $pdo->query("SELECT id, site_adi, tenant_id, yonetici_adi, DATEDIFF(paket_bitis_tarihi, CURDATE()) AS kalan_gun FROM siteler ORDER BY id DESC LIMIT 10")->fetchAll();
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0"><i class="fas fa-tachometer-alt"></i> Kontrol Paneli</h1>
    </div>
  </div>
  <section class="content">
    <div class="container-fluid">
      <!-- 4 KART -->
      <div class="row">
        <div class="col-lg-3 col-6">
          <div class="small-box bg-info">
            <div class="inner text-center">
              <h3><?= $site_sayisi ?></h3>
              <p>Toplam Site</p>
            </div>
            <div class="icon"><i class="fas fa-building"></i></div>
            <a href="siteler.php" class="small-box-footer">Detay <i class="fas fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <div class="col-lg-3 col-6">
          <div class="small-box bg-success">
            <div class="inner text-center">
              <h3>₺<?= number_format($toplam_gelir,0,'','.') ?></h3>
              <p>Şirket Geliri</p>
            </div>
            <div class="icon"><i class="fas fa-arrow-trend-up"></i></div>
            <a href="gelir_gider.php" class="small-box-footer">Detay <i class="fas fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <div class="col-lg-3 col-6">
          <div class="small-box bg-danger">
            <div class="inner text-center">
              <h3>₺<?= number_format($toplam_gider,0,'','.') ?></h3>
              <p>Şirket Gideri</p>
            </div>
            <div class="icon"><i class="fas fa-arrow-trend-down"></i></div>
            <a href="gelir_gider.php" class="small-box-footer">Detay <i class="fas fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <div class="col-lg-3 col-6">
          <div class="small-box bg-warning">
            <div class="inner text-center">
              <h3>₺<?= number_format($bakiye,0,'','.') ?></h3>
              <p>Net Bakiye</p>
            </div>
            <div class="icon"><i class="fas fa-wallet"></i></div>
            <a href="gelir_gider.php" class="small-box-footer">Detay <i class="fas fa-arrow-circle-right"></i></a>
          </div>
        </div>
      </div>

      <!-- HIZLI ERİŞİM -->
      <div class="card">
        <div class="card-header bg-gradient-navy">
          <h3 class="card-title"><i class="fas fa-rocket"></i> Hızlı Erişim</h3>
        </div>
        <div class="card-body">
          <div class="row text-center">
            <div class="col-lg-2 col-md-4 col-6 mb-4">
              <a href="siteler.php" class="btn btn-lg btn-block btn-info">
                <i class="fas fa-building fa-3x mb-2"></i><br>Site Ekle
              </a>
            </div>
            <div class="col-lg-2 col-md-4 col-6 mb-4">
              <a href="toplu_sms.php" class="btn btn-lg btn-block btn-success">
                <i class="fas fa-sms fa-3x mb-2"></i><br>Toplu SMS
              </a>
            </div>
            <div class="col-lg-2 col-md-4 col-6 mb-4">
              <a href="gelir_gider.php" class="btn btn-lg btn-block btn-warning">
                <i class="fas fa-money-bill-wave fa-3x mb-2"></i><br>Gelir Gider
              </a>
            </div>
            <div class="col-lg-2 col-md-4 col-6 mb-4">
              <a href="anlasmali_firmalar.php" class="btn btn-lg btn-block btn-primary">
                <i class="fas fa-handshake fa-3x mb-2"></i><br>İş Birliği
              </a>
            </div>
            <div class="col-lg-2 col-md-4 col-6 mb-4">
              <a href="anlasmali_firmalar.php" class="btn btn-lg btn-block btn-info">
                <i class="fas fa-handshake fa-3x mb-2"></i><br>Hizmetler
              </a>
            </div>
            <div class="col-lg-2 col-md-4 col-6 mb-4">
              <a href="ozel_teklifler.php" class="btn btn-lg btn-block btn-danger">
                <i class="fas fa-gift fa-3x mb-2"></i><br>Reklam Ekle
              </a>
            </div>
          </div>
        </div>
      </div>

      <!-- GELİR GİDER GRAFİĞİ (Şimdilik sabit veri, istersen sonra gerçek veriye çekeriz) -->
      <div class="card">
        <div class="card-header bg-gradient-info">
          <h3 class="card-title"><i class="fas fa-chart-line"></i> Şirket Gelir & Gider Trendi</h3>
          <div class="card-tools">
            <div class="btn-group">
              <button type="button" class="btn btn-tool active" id="haftalik">Haftalık</button>
              <button type="button" class="btn btn-tool" id="aylik">Aylık</button>
              <button type="button" class="btn btn-tool" id="yillik">Yıllık</button>
            </div>
          </div>
        </div>
        <div class="card-body">
          <canvas id="gelirGiderChart" height="120"></canvas>
        </div>
      </div>

      <!-- SON EKLENEN SİTELER -->
      <div class="card">
        <div class="card-header bg-gradient-success">
          <h3 class="card-title"><i class="fas fa-list"></i> Son Eklenen 10 Site</h3>
        </div>
        <div class="card-body table-responsive p-0">
          <table class="table table-hover">
            <thead>
              <tr>
                <th>Site Adı</th>
                <th>Yönetici</th>
                <th>Kalan Gün</th>
                <th>Tenant</th>
                <th>İşlem</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach($son_siteler as $s): ?>
              <tr>
                <td><strong><?= htmlspecialchars($s['site_adi']) ?></strong></td>
                <td><?= htmlspecialchars($s['yonetici_adi'] ?: 'Belirtilmemiş') ?></td>
                <td><span class="badge <?= ($s['kalan_gun'] ?? 0) < 30 ? 'bg-danger' : 'bg-success' ?>"><?= $s['kalan_gun'] ?? 'Süresiz' ?> gün</span></td>
                <td><code><?= htmlspecialchars($s['tenant_id']) ?></code></td>
                <td><a href="siteler.php?gozlem=<?= $s['id'] ?>" class="btn btn-info btn-sm"><i class="fas fa-eye"></i></a></td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const dataSets = {
        haftalik: {
            labels: ["Pzt", "Sal", "Çar", "Per", "Cum", "Cmt", "Paz"],
            gelir: [1200, 1400, 1000, 1800, 1600, 2200, 900],
            gider: [800, 900, 950, 700, 1100, 900, 600]
        },
        aylik: {
            labels: ["1-7", "8-14", "15-21", "22-28", "29-31"],
            gelir: [32000, 38000, 42000, 45000, 28000],
            gider: [22000, 25000, 28000, 30000, 18000]
        },
        yillik: {
            labels: ["Oca", "Şub", "Mar", "Nis", "May", "Haz", "Tem", "Ağu", "Eyl", "Eki", "Kas", "Ara"],
            gelir: [50000, 52000, 48000, 60000, 65000, 70000, 75000, 78000, 72000, 76000, 80000, 85000],
            gider: [30000, 32000, 31000, 35000, 36000, 38000, 40000, 42000, 41000, 43000, 44000, 46000]
        }
    };

    const ctx = document.getElementById("gelirGiderChart").getContext("2d");
    let chart = new Chart(ctx, {
        type: "line",
        data: {
            labels: dataSets.aylik.labels,
            datasets: [
                {
                    label: "Gelir",
                    data: dataSets.aylik.gelir,
                    borderColor: "#28a745",
                    backgroundColor: "rgba(40,167,69,0.1)",
                    tension: 0.4,
                    fill: true
                },
                {
                    label: "Gider",
                    data: dataSets.aylik.gider,
                    borderColor: "#dc3545",
                    backgroundColor: "rgba(220,53,69,0.1)",
                    tension: 0.4,
                    fill: true
                }
            ]
        },
        options: {
            responsive: true,
            plugins: { legend: { position: 'bottom' } },
            scales: { y: { beginAtZero: false } }
        }
    });

    document.getElementById('haftalik').onclick = () => updateChart('haftalik');
    document.getElementById('aylik').onclick = () => updateChart('aylik');
    document.getElementById('yillik').onclick = () => updateChart('yillik');

    function updateChart(tur) {
        chart.data.labels = dataSets[tur].labels;
        chart.data.datasets[0].data = dataSets[tur].gelir;
        chart.data.datasets[1].data = dataSets[tur].gider;
        chart.update();

        document.querySelectorAll('#haftalik, #aylik, #yillik').forEach(btn => btn.classList.remove('active'));
        document.getElementById(tur).classList.add('active');
    }
});
</script>

<?php include '../inc/footer.php'; ?>