<?php require_once '../config/database.php'; session_start();
if (isset($_SESSION['admin'])) header('Location: dashboard.php');

$hata = '';
if ($_POST) {
    $email = $_POST['email'];
    $sifre = $_POST['sifre'];
    $stmt = $pdo->prepare("SELECT * FROM super_admin WHERE email = ?");
    $stmt->execute([$email]);
    $admin = $stmt->fetch();
    if ($admin && password_verify($sifre, $admin['sifre'])) {
        $_SESSION['admin'] = true;
        $_SESSION['rol'] = 'superadmin';
        header('Location: dashboard.php');
        exit;
    }
    $hata = "E-posta veya şifre hatalı!";
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Süper Admin Giriş | YönetimOnline</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
  <style>
    body {font-family: 'Poppins', sans-serif; background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%); min-height: 100vh; display: flex; align-items: center; justify-content: center;}
    .login-box {width: 460px; margin: 0 auto;}
    .card {border-radius: 25px; box-shadow: 0 25px 60px rgba(0,0,0,0.5); overflow: hidden;}
    .card-header {background: linear-gradient(135deg, #1e3c72, #2a5298); color: white; text-align: center; padding: 40px 20px;}
    .card-header img {width: 200px; margin-bottom: 20px;}
    .card-header h2 {margin: 0; font-weight: 700; font-size: 28px;}
    .card-header p {margin: 10px 0 0; font-size: 16px; opacity: 0.9;}
    .card-body {padding: 50px 40px; background: #fff;}
    .input-group .form-control {height: 55px; font-size: 17px; border-radius: 12px;}
    .input-group-text {border-radius: 12px 0 0 12px;}
    .btn-primary {height: 55px; font-size: 19px; font-weight: 700; background: #2a5298; border: none; border-radius: 12px;}
    .btn-primary:hover {background: #1e3c72;}
    .alert {border-radius: 12px; text-align: center;}
    @media (max-width: 480px) {
      .login-box {width: 95%; padding: 15px;}
      .card-header img {width: 160px;}
      .card-header h2 {font-size: 24px;}
      .card-body {padding: 40px 25px;}
    }
  </style>
</head>
<body>
<div class="login-box">
  <div class="card">
    <div class="card-header">
      <img src="../img/logo.png" alt="YönetimOnline">
      <h2>SÜPER ADMİN GİRİŞ</h2>
      <p>Tüm siteleri yönet</p>
    </div>
    <div class="card-body">
      <?php if($hata) echo '<div class="alert alert-danger">'.$hata.'</div>'; ?>
      <form method="post">
        <div class="input-group mb-4">
          <input type="email" name="email" class="form-control" placeholder="Admin e-posta" required value="admin@yonetimonline.com.tr">
          <div class="input-group-append">
            <div class="input-group-text"><i class="fas fa-crown"></i></div>
          </div>
        </div>
        <div class="input-group mb-4">
          <input type="password" name="sifre" class="form-control" placeholder="Şifre" required value="123456">
          <div class="input-group-append">
            <div class="input-group-text"><i class="fas fa-key"></i></div>
          </div>
        </div>
        <button type="submit" class="btn btn-primary btn-block btn-lg">GİRİŞ YAP</button>
      </form>
    </div>
  </div>
</div>
</body>
</html>