<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['admin'])) header('Location: login.php');
$_SESSION['rol'] = 'superadmin';

$basari = $hata = '';

// NetGSM ayarları (kendi bilgilerini gir)
define('NETGSM_USER', '90XXXXXXXXXX');
define('NETGSM_PASS', 'SIFREN');
define('NETGSM_HEADER', 'YONETIMONLINE');

// Netgsm bakiye sorgulama (basit, hata durumunda '-' döner)
function netgsmBakiye() {
    // Eğer gerçek endpoint veya kimlik bilgileri yoksa hata fırlatmak yerine güvenli fallback ver
    if (NETGSM_USER === '90XXXXXXXXXX' || NETGSM_PASS === 'SIFREN') {
        return '-';
    }

    $xml = '<?xml version="1.0" encoding="UTF-8"?>
    <mainbody>
      <header>
        <company>Netgsm</company>
        <usercode>' . NETGSM_USER . '</usercode>
        <password>' . NETGSM_PASS . '</password>
        <type>1:1</type>
      </header>
    </mainbody>';

    $ch = curl_init('https://api.netgsm.com.tr/xmlhttppost/get-balance');
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => ['Content-Type: text/xml; charset=utf-8'],
        CURLOPT_POSTFIELDS => $xml,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => true
    ]);
    $resp = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($resp === false || $err) return '-';

    // Netgsm döndüğü format farklı olabilir; basitçe rakam bulursak onu döndür
    if (preg_match('/([0-9]+(?:\.[0-9]+)?)/', $resp, $m)) {
        return $m[1];
    }
    return '-';
}

$bakiye = netgsmBakiye(); // bakiye sorgula

// normalize telefon (string) -> array of cleaned numbers compatible with NetGSM (90XXXXXXXXXX)
function normalizeNumber($num) {
    $n = preg_replace('/[^0-9]/', '', (string)$num);
    if ($n === '') return '';
    // Eğer + ile başlıyorsa zaten temizlendi
    // Türk numaraları: eğer 11 haneyse ve başında 0 ise remove leading 0 -> 10 haneli
    if (strlen($n) === 11 && substr($n,0,1) === '0') $n = substr($n,1);
    // Eğer 10 haneli (532...), prefix 90
    if (strlen($n) === 10) $n = '90'.$n;
    // Eğer 12 haneli ve başında 90 ise kabul et
    if (strlen($n) === 12 && substr($n,0,2) === '90') return $n;
    // Diğer durumlarda döndür (hitap eden format olmayabilir)
    return $n;
}

// SMS GÖNDER
if (isset($_POST['gonder'])) {
    $mesaj = trim($_POST['mesaj'] ?? '');
    $hedef = $_POST['hedef'] ?? '';

    if ($mesaj === '') {
        $hata = "Mesaj boş olamaz.";
    } else {
        // hedef numaraları çek
        if ($hedef === 'tum') {
            $stmt = $pdo->query("SELECT yonetici_tel FROM siteler WHERE yonetici_tel IS NOT NULL AND yonetici_tel != ''");
            $raw = $stmt->fetchAll(PDO::FETCH_COLUMN);
        } else {
            $stmt = $pdo->prepare("SELECT yonetici_tel FROM siteler WHERE id = ? AND yonetici_tel IS NOT NULL AND yonetici_tel != ''");
            $stmt->execute([(int)$hedef]);
            $raw = $stmt->fetchAll(PDO::FETCH_COLUMN);
        }

        $numbers = [];
        foreach ($raw as $r) {
            $n = normalizeNumber($r);
            if ($n) $numbers[] = $n;
        }
        // unique ve yeniden indexle
        $numbers = array_values(array_unique($numbers));

        if (empty($numbers)) {
            $hata = "Gönderilecek geçerli numara bulunamadı.";
        } else {
            // XML bulk oluştur (NetGSM bulk API kullanımı)
            $nos = '';
            foreach ($numbers as $no) {
                $nos .= "<no>{$no}</no>";
            }

            // limit karakter: NetGSM 160 karakter tek SMS; multipart handled by provider but we keep 160 as limit
            if (mb_strlen($mesaj) > 160) {
                // yine gönderilsin ama uyar
                $hata = "Uyarı: Mesaj 160 karakterden uzun, operatör çoklu SMS ücreti uygulayabilir.";
                // not block; continue to send
            }

            $xml = '<?xml version="1.0" encoding="UTF-8"?>
<mainbody>
  <header>
    <company>Netgsm</company>
    <usercode>' . NETGSM_USER . '</usercode>
    <password>' . NETGSM_PASS . '</password>
    <type>1:n</type>
    <msgheader>' . NETGSM_HEADER . '</msgheader>
  </header>
  <body>
    <msg><![CDATA[' . $mesaj . ']]></msg>
    ' . $nos . '
  </body>
</mainbody>';

            $ch = curl_init('https://api.netgsm.com.tr/xmlbulkhttppost/send');
            curl_setopt_array($ch, [
                CURLOPT_POST => true,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HTTPHEADER => ['Content-Type: text/xml; charset=utf-8'],
                CURLOPT_POSTFIELDS => $xml,
                CURLOPT_TIMEOUT => 15,
                CURLOPT_SSL_VERIFYPEER => true
            ]);

            $response = curl_exec($ch);
            $curlErr = curl_error($ch);
            curl_close($ch);

            if ($response === false || $curlErr) {
                $hata = "Gönderim sırasında ağ hatası: " . ($curlErr ?: 'curl_exec hata');
            } else {
                // Netgsm genellikle '00' ile başlayan durum kodu veya XML içinde code 00 dönebilir.
                if (strpos($response, '00') === 0 || strpos($response, '<code>00') !== false || strpos($response, '<result>00') !== false) {
                    $basari = "SMS gönderildi! (".count($numbers)." adet)";
                    // Log tut
                    try {
                        $pdo->prepare("INSERT INTO toplu_sms_log (mesaj, hedef, adet, tarih) VALUES (?, ?, ?, NOW())")
                            ->execute([$mesaj, $hedef === 'tum' ? 'Tüm Siteler' : $hedef, count($numbers)]);
                    } catch (Exception $e) {
                        // log hatası uygulamayı bozmamalı
                    }
                } else {
                    // cevap XML veya metin olabilir — detaylı hata çıkarmak için döndürüleni sakla
                    $hata = "Gönderim başarısız. Servis cevabı: " . htmlspecialchars($response);
                }
            }
        }
    }
}

// Siteler listesi
$siteler = $pdo->query("SELECT id, site_adi, yonetici_tel FROM siteler ORDER BY site_adi")->fetchAll();
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>

<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0"><i class="fas fa-sms"></i> Toplu SMS</h1>
    </div>
  </div>

  <section class="content">
    <div class="container-fluid">

      <!-- BAKİYE -->
      <div class="row mb-4">
        <div class="col-12">
          <div class="info-box bg-gradient-info">
            <span class="info-box-icon"><i class="fas fa-wallet"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">NetGSM Bakiye</span>
              <span class="info-box-number"><?= htmlspecialchars($bakiye) ?> SMS</span>
            </div>
          </div>
        </div>
      </div>

      <?php if($basari): ?><div class="alert alert-success"><?= htmlspecialchars($basari) ?></div><?php endif; ?>
      <?php if($hata): ?><div class="alert alert-danger"><?= htmlspecialchars($hata) ?></div><?php endif; ?>

      <!-- FORM -->
      <div class="card card-primary shadow-lg">
        <div class="card-header bg-gradient-navy text-white">
          <h3 class="card-title"><i class="fas fa-sms"></i> SMS Gönder</h3>
        </div>
        <form method="post">
          <div class="card-body">
            <div class="form-group">
              <label>Hedef</label>
              <select name="hedef" class="form-control" required>
                <option value="tum">Tüm Siteler</option>
                <?php foreach($siteler as $s): ?>
                  <option value="<?= (int)$s['id'] ?>"><?= htmlspecialchars($s['site_adi']) ?> (Tel: <?= htmlspecialchars($s['yonetici_tel'] ?: 'Yok') ?>)</option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="form-group">
              <label>Mesaj (max 160 karakter)</label>
              <textarea id="mesaj" name="mesaj" class="form-control" rows="5" maxlength="160" required><?= htmlspecialchars($_POST['mesaj'] ?? '') ?></textarea>
              <small class="float-right text-muted"><span id="karakter">0</span>/160</small>
            </div>
          </div>
          <div class="card-footer text-center">
            <button type="submit" name="gonder" class="btn btn-primary btn-lg px-5"><i class="fas fa-paper-plane"></i> GÖNDER</button>
          </div>
        </form>
      </div>

    </div>
  </section>
</div>

<script>
(function(){
  var ta = document.getElementById('mesaj');
  var counter = document.getElementById('karakter');
  if(ta && counter){
    counter.textContent = ta.value.length;
    ta.addEventListener('input', function(){ counter.textContent = this.value.length; });
  }
})();
</script>

<?php include '../inc/footer.php'; ?>
