<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['uye_id'])) {
    header('Location: login.php');
    exit;
}
$uye_id = (int)$_SESSION['uye_id'];
$site_id = (int)$_SESSION['site_id'];

/* TOPLAM AİDAT BORCU */
$stmt = $pdo->prepare("
    SELECT COALESCE(SUM(miktar), 0) AS aidat_borc
    FROM aidatlar
    WHERE uye_id = ? AND odendi = 0
");
$stmt->execute([$uye_id]);
$aidat_borc = $stmt->fetchColumn();

/* AİDAT BORÇLARI DETAYLARI */
$aidat_borclar = $pdo->prepare("
    SELECT ay, miktar
    FROM aidatlar
    WHERE uye_id = ? AND odendi = 0
    ORDER BY ay ASC
");
$aidat_borclar->execute([$uye_id]);
$aidat_borclar = $aidat_borclar->fetchAll();

/* DEMİRBAŞ BORÇLARI TOPLAMI */
$demirbas_stmt = $pdo->prepare("
    SELECT COALESCE(SUM(tutar), 0) AS demirbas_borc
    FROM demirbas_borclar
    WHERE uye_id = ? AND odendi = 0
");
$demirbas_stmt->execute([$uye_id]);
$demirbas_borc = $demirbas_stmt->fetchColumn();

/* DEMİRBAŞ BORÇLARI DETAYLARI */
$demirbas_borclar = $pdo->prepare("
    SELECT b.tutar, d.ad as demirbas_ad
    FROM demirbas_borclar b
    JOIN demirbaslar d ON b.demirbas_id = d.id
    WHERE b.uye_id = ? AND b.odendi = 0
");
$demirbas_borclar->execute([$uye_id]);
$demirbas_borclar = $demirbas_borclar->fetchAll();

/* GENEL TOPLAM BORÇ */
$toplam_borc = $aidat_borc + $demirbas_borc;

/* DUYURULAR */
$duyurular = $pdo->query("
    SELECT * FROM duyurular
    WHERE site_id = $site_id AND durum = 'yayinda'
    ORDER BY yayin_tarihi DESC
    LIMIT 3
")->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Üye Paneli • Dashboard</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
<style>
    body {
        font-family: 'Poppins', sans-serif !important;
        background: #f5f7fb !important;
    }
    .top-banner {
        background: linear-gradient(135deg, #4c6ef5 0%, #82a0ff 100%);
        border-radius: 20px;
        padding: 40px 20px;
        color: white;
        text-align: center;
        margin-bottom: 30px;
        box-shadow: 0 8px 25px rgba(0,0,0,0.12);
    }
    .top-banner h1 {
        font-size: 2rem;
    }
    .top-banner p {
        font-size: 1rem;
    }
    .borc-card {
        border-radius: 20px;
        background: #ffffff;
        box-shadow: 0 10px 40px rgba(0,0,0,0.08);
        padding: 30px 20px;
        text-align: center;
    }
    .borc-amount {
        font-weight: 700;
        margin-bottom: 10px;
    }
    .borc-yok {
        color: #28a745 !important;
    }
    @media (min-width: 992px) {
        .borc-amount { font-size: 3.5rem; }
        .borc-card { padding: 40px; }
        .top-banner { padding: 40px 30px; }
        .top-banner h1 { font-size: 2.5rem; }
    }
    @media (max-width: 991px) and (min-width: 768px) {
        .borc-amount { font-size: 3rem; }
    }
    @media (max-width: 767px) {
        .borc-amount { font-size: 2.5rem; }
        .borc-card { padding: 25px 15px; }
        .top-banner { padding: 30px 15px; margin-bottom: 20px; }
        .top-banner h1 { font-size: 1.8rem; }
        .top-banner p { font-size: 0.95rem; }
    }
    .shortcut-card {
        height: 120px;
        border-radius: 18px;
        font-size: 1rem;
        transition: 0.3s;
        padding-top: 15px;
    }
    .shortcut-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 15px 30px rgba(0,0,0,0.1);
    }
    .shortcut-card i {
        font-size: 2.5rem;
    }
    .ozel-teklif-btn {
        height: 200px;
        border-radius: 30px;
        background: linear-gradient(135deg, #ff9f1a, #ff6b35);
        color: white;
        font-size: 1.8rem;
        padding-top: 25px;
    }
    @media (max-width: 767px) {
        .ozel-teklif-btn {
            height: 180px;
            font-size: 1.5rem;
        }
        .ozel-teklif-btn i {
            font-size: 3.5rem;
        }
    }
    #odemeModal .btn-lg {
        padding: 20px;
        font-size: 1.2rem;
    }
    @media (max-width: 767px) {
        #odemeModal .btn-lg {
            padding: 30px 15px;
            font-size: 1.1rem;
        }
        #odemeModal i {
            font-size: 3rem !important;
        }
    }
</style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper p-3 p-md-4">
    <!-- ÜST BANNER -->
    <div class="top-banner">
        <h1 class="display-6 mb-3">Hoş Geldiniz, <?= htmlspecialchars($_SESSION['ad_soyad']) ?></h1>
        <p>Site yönetimiyle ilgili tüm işlemlerinizi buradan kolayca takip edebilirsiniz.</p>
    </div>
    <div class="container-fluid">
        <!-- BORÇ KARTI -->
        <div class="row justify-content-center mb-4 mb-md-5">
            <div class="col-12 col-lg-8">
                <div class="borc-card">
                    <div class="borc-amount <?= $toplam_borc == 0 ? 'borc-yok' : '' ?>">
                        ₺<?= number_format($toplam_borc, 2) ?>
                    </div>
                    <p class="mt-3 mb-4 h5">
                        <?= $toplam_borc == 0 ? 'Borç Yok - Teşekkür Ederiz!' : 'Toplam Borcunuz' ?>
                    </p>
                    <?php if ($toplam_borc > 0): ?>
                        <button class="btn btn-danger btn-lg px-5 py-3" data-toggle="modal" data-target="#odemeModal">
                            <i class="fas fa-credit-card fa-lg mr-2"></i> ÖDEME YAP
                        </button>
                    <?php else: ?>
                        <button class="btn btn-success btn-lg px-5 py-3" disabled>
                            <i class="fas fa-check-circle fa-lg mr-2"></i> BORCUNUZ YOK
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- DEMİRBAŞ BORÇLARI -->
        <?php if (!empty($demirbas_borclar)): ?>
        <div class="card shadow mb-4 mb-md-5">
            <div class="card-header bg-warning text-white">
                <h3 class="card-title"><i class="fas fa-tools mr-2"></i> Demirbaş Borçlarınız</h3>
            </div>
            <div class="card-body">
                <ul class="list-group">
                    <?php foreach($demirbas_borclar as $db): ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <?= htmlspecialchars($db['demirbas_ad']) ?>
                        <span class="badge bg-danger">₺<?= number_format($db['tutar'], 2) ?></span>
                    </li>
                    <?php endforeach; ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                        Toplam Demirbaş Borcu
                        <span class="badge bg-dark">₺<?= number_format($demirbas_borc, 2) ?></span>
                    </li>
                </ul>
            </div>
        </div>
        <?php endif; ?>

        <!-- AİDAT BORÇLARI -->
        <?php if (!empty($aidat_borclar)): ?>
        <div class="card shadow mb-4 mb-md-5">
            <div class="card-header bg-danger text-white">
                <h3 class="card-title"><i class="fas fa-money-bill-wave mr-2"></i> Aidat Borçlarınız</h3>
            </div>
            <div class="card-body">
                <ul class="list-group">
                    <?php foreach ($aidat_borclar as $aidat): ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <strong><?= htmlspecialchars($aidat['ay']) ?></strong>
                        <span class="badge bg-danger">₺<?= number_format($aidat['miktar'], 2) ?></span>
                    </li>
                    <?php endforeach; ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center font-weight-bold">
                        Toplam Aidat Borcu
                        <span class="badge bg-dark">₺<?= number_format($aidat_borc, 2) ?></span>
                    </li>
                </ul>
            </div>
        </div>
        <?php endif; ?>

        <!-- DUYURULAR -->
        <div class="card shadow mb-4 mb-md-5">
            <div class="card-header bg-primary text-white">
                <h3 class="card-title"><i class="fas fa-bullhorn mr-2"></i> Son Duyurular</h3>
            </div>
            <div class="card-body">
                <?php if (empty($duyurular)): ?>
                    <p class="text-center text-muted py-4">Henüz duyuru bulunmamaktadır.</p>
                <?php else: ?>
                    <?php foreach($duyurular as $d): ?>
                    <div class="alert alert-light border-left border-primary p-4 mb-3">
                        <h5 class="font-weight-bold"><?= htmlspecialchars($d['baslik']) ?></h5>
                        <p class="text-muted small mb-2"><?= date('d.m.Y H:i', strtotime($d['yayin_tarihi'])) ?></p>
                        <p><?= nl2br(htmlspecialchars($d['icerik'])) ?></p>
                    </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>

        <!-- KISAYOLLAR -->
        <div class="row text-center mb-4 mb-md-5">
            <div class="col-6 col-md-3 mb-3">
                <a href="hesap_bilgi.php" class="btn btn-light shortcut-card w-100 shadow-sm">
                    <i class="fas fa-wallet text-warning mb-2"></i><br>
                    Hesap Bilgisi
                </a>
            </div>
            <div class="col-6 col-md-3 mb-3">
                <a href="rapor_merkez.php" class="btn btn-light shortcut-card w-100 shadow-sm">
                    <i class="fas fa-chart-line text-info mb-2"></i><br>
                    Raporlar
                </a>
            </div>
            <div class="col-6 col-md-3 mb-3">
                <a href="anketler.php" class="btn btn-light shortcut-card w-100 shadow-sm">
                    <i class="fas fa-poll text-danger mb-2"></i><br>
                    Anketler
                </a>
            </div>
            <div class="col-6 col-md-3 mb-3">
                <a href="destek.php" class="btn btn-light shortcut-card w-100 shadow-sm">
                    <i class="fas fa-headset text-dark mb-2"></i><br>
                    Destek Paneli
                </a>
            </div>
        </div>

        <!-- ÖZEL TEKLİFLER -->
        <div class="text-center mb-4 mb-md-5">
            <a href="ozel_teklifler.php" class="btn ozel-teklif-btn w-100 shadow-lg d-block">
                <i class="fas fa-gift mb-3"></i>
                ÖZEL TEKLİFLER
            </a>
        </div>
    </div>
</div>

<!-- ÖDEME MODAL -->
<div class="modal fade" id="odemeModal">
    <div class="modal-dialog modal-lg">
        <div class="modal-content rounded-0">
            <div class="modal-header bg-danger text-white">
                <h4 class="modal-title">Aidat Ödeme</h4>
                <button type="button" class="close text-white" data-dismiss="modal">×</button>
            </div>
            <div class="modal-body py-5 text-center">
                <div class="row">
                    <div class="col-md-6 mb-3 mb-md-0">
                        <a href="eft_ode.php" class="btn btn-success btn-block btn-lg p-5">
                            <i class="fas fa-university mb-3"></i><br>EFT / HAVALE
                        </a>
                    </div>
                    <div class="col-md-6">
                        <a href="kredi_karti.php" class="btn btn-primary btn-block btn-lg p-5">
                            <i class="fas fa-credit-card mb-3"></i><br>KREDİ KARTI İLE ÖDE
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../inc/footer.php'; ?>
</div>
</body>
</html>