<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['uye_id']) || !isset($_SESSION['site_id'])) {
    header('Location: login.php');
    exit;
}
$uye_id = (int)$_SESSION['uye_id'];
$site_id = (int)$_SESSION['site_id'];

// Modül aktif mi kontrol et
$stmt = $pdo->prepare("SELECT destek_modul_aktif FROM siteler WHERE id = ?");
$stmt->execute([$site_id]);
$site = $stmt->fetch();
$modul_aktif = $site && $site['destek_modul_aktif'];

$basari = '';
$hata = '';

// Site Profil Bilgilerini Çek (modül kapalıysa gösterilecek)
$stmt = $pdo->prepare("SELECT * FROM site_profil WHERE site_id = ?");
$stmt->execute([$site_id]);
$profil = $stmt->fetch() ?: [];

// TALEP EKLE (sadece modül aktifse)
if ($modul_aktif && isset($_POST['gonder'])) {
    $konu = trim($_POST['konu'] ?? '');
    $mesaj = trim($_POST['mesaj'] ?? '');
    $puan = (int)$_POST['puan'];
    $anonim = isset($_POST['anonim']) ? 1 : 0;

    if ($konu === '' || $mesaj === '' || $puan < 1 || $puan > 5) {
        $hata = "Lütfen tüm alanları doldurun.";
    } else {
        $stmt = $pdo->prepare("SELECT ad_soyad FROM uyeler WHERE id = ? AND site_id = ?");
        $stmt->execute([$uye_id, $site_id]);
        $uye = $stmt->fetch();
        $ad_soyad = $anonim ? 'Anonim' : ($uye['ad_soyad'] ?? 'Bilinmiyor');

        $stmt = $pdo->prepare("INSERT INTO destek_talepleri (site_id, konu, mesaj, uye_ad_soyad, uye_id, anonim, puan, eklenme_tarihi) VALUES (?, ?, ?, ?, ?, ?, ?, NOW())");
        $stmt->execute([$site_id, $konu, $mesaj, $ad_soyad, $anonim ? null : $uye_id, $anonim, $puan]);
        $basari = "Talebiniz gönderildi, teşekkür ederiz!";
    }
}

// LİSTE (her zaman gösterilir, modül kapalı olsa da)
$stmt = $pdo->prepare("SELECT * FROM destek_talepleri WHERE site_id = ? ORDER BY eklenme_tarihi DESC");
$stmt->execute([$site_id]);
$talepler = $stmt->fetchAll();
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Site Destek Paneli</h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php if($basari): ?><div class="alert alert-success"><?= htmlspecialchars($basari) ?></div><?php endif; ?>
    <?php if($hata): ?><div class="alert alert-danger"><?= htmlspecialchars($hata) ?></div><?php endif; ?>

    <?php if (!$modul_aktif): ?>
      <div class="alert alert-info">
        İhtiyaçlarınız ve sorularınız için bizimle her zaman iletişime geçebilirsiniz.
      </div>

      <!-- Site Profil Bilgileri (Modül Kapalıyken Gösterilir) -->
      <div class="card card-secondary">
        <div class="card-header"><h3 class="card-title">Yönetim ve İletişim Bilgileri</h3></div>
        <div class="card-body">
          <p><strong>Yönetici Adı Soyadı:</strong> <?= htmlspecialchars($profil['yonetici_ad_soyad'] ?? '-') ?></p>
          <p><strong>Telefon:</strong> <?= htmlspecialchars($profil['yonetici_telefon'] ?? '-') ?></p>
          <p><strong>E-posta:</strong> <?= htmlspecialchars($profil['yonetici_mail'] ?? '-') ?></p>
          <p><strong>Çalışma Saatleri:</strong> <?= nl2br(htmlspecialchars($profil['calisma_saatleri'] ?? '-')) ?></p>
          <p><strong>İletişim Bilgileri:</strong> <?= nl2br(htmlspecialchars($profil['iletisim_bilgileri'] ?? '-')) ?></p>
          <p><strong>Çalışan Bilgileri:</strong> <?= nl2br(htmlspecialchars($profil['calisan_bilgileri'] ?? '-')) ?></p>
        </div>
      </div>
    <?php else: ?>
      <!-- YENİ TALEP FORMU -->
      <div class="card card-primary mb-4">
        <div class="card-header"><h3 class="card-title">Yeni Öneri / Şikayet Gönder</h3></div>
        <div class="card-body">
          <form method="post">
            <div class="form-group">
              <label>Konu</label>
              <input name="konu" class="form-control" placeholder="Konu başlığı..." required>
            </div>
            <div class="form-group">
              <label>Mesaj</label>
              <textarea name="mesaj" class="form-control" rows="5" placeholder="Detaylı açıklamanız..." required></textarea>
            </div>
            <div class="form-group">
              <label>Yönetim Performansı Puanı (1-5)</label>
              <select name="puan" class="form-control" required>
                <option value="">Puan Seçin</option>
                <option value="1">1 - Çok Kötü</option>
                <option value="2">2 - Kötü</option>
                <option value="3">3 - Orta</option>
                <option value="4">4 - İyi</option>
                <option value="5">5 - Mükemmel</option>
              </select>
            </div>
            <div class="form-check mb-3">
              <input type="checkbox" name="anonim" value="1" class="form-check-input" id="anonim">
              <label class="form-check-label" for="anonim">Anonim olarak gönder (isminiz görünmez)</label>
            </div>
            <div class="text-right">
              <button name="gonder" class="btn btn-primary btn-lg">Gönder</button>
            </div>
          </form>
        </div>
      </div>

      <!-- TALEP LİSTESİ -->
      <div class="card">
        <div class="card-header"><h3 class="card-title">Gönderilen Talepler</h3></div>
        <div class="card-body table-responsive p-0">
          <table class="table table-hover">
            <thead>
              <tr>
                <th>Konu</th>
                <th>Gönderen</th>
                <th>Mesaj</th>
                <th>Puan</th>
                <th>Tarih</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($talepler)): ?>
                <tr><td colspan="5" class="text-center">Henüz talep gönderilmemiş.</td></tr>
              <?php else: ?>
                <?php foreach($talepler as $t): ?>
                  <tr>
                    <td><?= htmlspecialchars($t['konu']) ?></td>
                    <td><?= htmlspecialchars($t['uye_ad_soyad']) ?></td>
                    <td><?= nl2br(htmlspecialchars($t['mesaj'])) ?></td>
                    <td><span class="badge bg-primary"><?= $t['puan'] ?></span></td>
                    <td><?= date('d.m.Y H:i', strtotime($t['eklenme_tarihi'])) ?></td>
                  </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    <?php endif; ?>
  </div></section>
</div>
<?php include '../inc/footer.php'; ?>