<?php
require_once '../config/database.php';
session_start();

if (!isset($_SESSION['uye_id'])) {
    header('Location: login.php');
    exit;
}

$site_id = (int)$_SESSION['site_id'];

// Üyeye ait toplam borç (tekrar gösterelim ki ne kadar yatıracağını bilsin)
$stmt = $pdo->prepare("
    SELECT COALESCE(SUM(miktar), 0) AS toplam_borc
    FROM aidatlar
    WHERE uye_id = ? AND odendi = 0
");
$stmt->execute([$_SESSION['uye_id']]);
$borc = $stmt->fetchColumn();

// Banka hesaplarını çek
$hesaplar = $pdo->prepare("SELECT * FROM banka_hesaplari WHERE site_id = ? ORDER BY banka_adi");
$hesaplar->execute([$site_id]);
$hesaplar = $hesaplar->fetchAll(PDO::FETCH_ASSOC);
?>

<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>

<div class="content-wrapper p-4">
    <div class="container-fluid">

        <!-- Üst Bilgilendirme -->
        <div class="card shadow-lg border-0 rounded-lg mb-5" style="background: linear-gradient(135deg, #4c6ef5, #82a0ff); color: white;">
            <div class="card-body text-center py-5">
                <h2 class="mb-3"><i class="fas fa-university fa-2x"></i> EFT / HAVALE İLE ÖDEME</h2>
                <h4>Toplam Borcunuz: <strong>₺<?= number_format($borc, 2, ',', '.') ?></strong></h4>
                <p class="lead mt-4">Lütfen borcunuzu aşağıdaki banka hesaplarımızdan birine yatırın.<br>
                Açıklama kısmına <strong>"<?= htmlspecialchars($_SESSION['ad_soyad']) ?> - <?= htmlspecialchars($_SESSION['daire_no']) ?>"</strong> yazmayı unutmayın!</p>
            </div>
        </div>

        <?php if (empty($hesaplar)): ?>
            <div class="alert alert-warning text-center">
                <i class="fas fa-exclamation-triangle fa-2x mb-3"></i><br>
                Henüz banka hesabı tanımlanmamış. Lütfen yönetici ile iletişime geçin.
            </div>
        <?php else: ?>
            <div class="row">
                <?php foreach ($hesaplar as $h): ?>
                <div class="col-lg-6 col-xl-4 mb-4">
                    <div class="card shadow-sm border-0 h-100 hover-lift transition">
                        <div class="card-header bg-primary text-white text-center py-3">
                            <h5 class="mb-0"><i class="fas fa-building-columns mr-2"></i><?= htmlspecialchars($h['banka_adi']) ?></h5>
                        </div>
                        <div class="card-body">
                            <?php if ($h['sube']): ?>
                                <p class="mb-2"><strong>Şube:</strong> <?= htmlspecialchars($h['sube']) ?></p>
                            <?php endif; ?>
                            <?php if ($h['hesap_sahibi']): ?>
                                <p class="mb-2"><strong>Alıcı:</strong> <?= htmlspecialchars($h['hesap_sahibi']) ?></p>
                            <?php endif; ?>
                            <p class="mb-3"><strong>Tür:</strong> 
                                <span class="badge badge-info"><?= ucfirst(str_replace('aidat', 'Aidat Hesabı', $h['hesap_turu'])) ?></span>
                            </p>

                            <div class="input-group">
                                <input type="text" class="form-control font-weight-bold text-center" 
                                       value="<?= htmlspecialchars($h['iban']) ?>" readonly style="font-size:1.1rem;">
                                <div class="input-group-append">
                                    <button class="btn btn-success" type="button"
                                            onclick="copyIBAN('<?= htmlspecialchars($h['iban']) ?>')">
                                        <i class="fas fa-copy"></i> Kopyala
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <div class="text-center mt-4">
            <a href="dashboard.php" class="btn btn-secondary btn-lg px-5">
    <i class="fas fa-arrow-left mr-2"></i> Panele Dön
</a>
        </div>
    </div>
</div>

<style>
    .hover-lift { transition: all 0.3s ease; }
    .hover-lift:hover { transform: translateY(-10px); box-shadow: 0 20px 40px rgba(0,0,0,0.15) !important; }
</style>

<script>
function copyIBAN(iban) {
    navigator.clipboard.writeText(iban).then(() => {
        alert('IBAN kopyalandı: ' + iban);
    }).catch(() => {
        // fallback
        prompt('Kopyalamak için Ctrl+C basın:', iban);
    });
}
</script>

<?php include '../inc/footer.php'; ?>