<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['uye_id'])) {
    header('Location: login.php');
    exit;
}
$uye_id = (int)$_SESSION['uye_id'];
$basari = $hata = '';

// Aidat borcu (ödenmemiş)
try {
    $stmt = $pdo->prepare("SELECT COALESCE(SUM(miktar), 0) FROM aidatlar WHERE uye_id = ? AND odendi = 0");
    $stmt->execute([$uye_id]);
    $aidat_borcu = (float)$stmt->fetchColumn();
} catch (Exception $e) {
    $hata = "Aidat borcu hesaplanamadı.";
    $aidat_borcu = 0;
}

// Demirbaş borcu (ödenmemiş)
try {
    $stmt = $pdo->prepare("SELECT COALESCE(SUM(tutar), 0) FROM demirbas_borclar WHERE uye_id = ? AND odendi = 0");
    $stmt->execute([$uye_id]);
    $demirbas_borcu = (float)$stmt->fetchColumn();
} catch (Exception $e) {
    $hata = "Demirbaş borcu hesaplanamadı.";
    $demirbas_borcu = 0;
}

// Toplam borç (aidat + demirbaş)
$toplamBorc = $aidat_borcu + $demirbas_borcu;

// Toplam ödenen (tahsilatlar)
try {
    $stmt = $pdo->prepare("SELECT COALESCE(SUM(miktar), 0) FROM tahsilatlar WHERE uye_id = ?");
    $stmt->execute([$uye_id]);
    $toplamOdenen = (float)$stmt->fetchColumn();
} catch (Exception $e) {
    $hata = "Ödenen hesaplanamadı: " . $e->getMessage();
    $toplamOdenen = 0;
}

// Bekleyen aidatlar listesi
try {
    $stmt = $pdo->prepare("SELECT id, ay, miktar FROM aidatlar WHERE uye_id = ? AND odendi = 0 ORDER BY id DESC");
    $stmt->execute([$uye_id]);
    $bekleyen_aidat = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $hata = "Bekleyen aidatlar yüklenemedi.";
    $bekleyen_aidat = [];
}

// Bekleyen demirbaş borçları listesi
try {
    $stmt = $pdo->prepare("SELECT b.tutar, d.ad AS demirbas_ad FROM demirbas_borclar b JOIN demirbaslar d ON b.demirbas_id = d.id WHERE b.uye_id = ? AND b.odendi = 0 ORDER BY b.id DESC");
    $stmt->execute([$uye_id]);
    $bekleyen_demirbas = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $hata = "Bekleyen demirbaş borçları yüklenemedi.";
    $bekleyen_demirbas = [];
}

// Ödenmiş tahsilatlar listesi
try {
    $stmt = $pdo->prepare("SELECT id, miktar, tarih, aciklama, makbuz_no FROM tahsilatlar WHERE uye_id = ? ORDER BY tarih DESC");
    $stmt->execute([$uye_id]);
    $odenmis = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $hata = "Ödenmiş tahsilatlar yüklenemedi: " . $e->getMessage();
    $odenmis = [];
}

include '../inc/header.php';
include '../inc/sidebar.php';
include '../inc/navbar.php';
?>
<style>
.card-header-warning {
    background-color: #ffc107 !important;
    color: #212529 !important;
}
.card-border {
    border: 1px solid #dee2e6;
    border-radius: 0.5rem;
}
</style>
<div class="content-wrapper">
  <section class="content p-3">
    <div class="container-fluid">
      <?php if ($hata): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($hata) ?></div>
      <?php endif; ?>
      <div class="row mb-4">
        <div class="col-12 col-md-6 mb-3">
          <div class="card shadow-sm card-border">
            <div class="card-body">
              <h5 class="text-muted">Toplam Borcunuz</h5>
              <h2 class="font-weight-bold">₺<?= number_format($toplamBorc, 2, ',', '.') ?></h2>
              <?php if ($toplamBorc > 0): ?>
                <a href="#" class="btn btn-danger mt-3" data-toggle="modal" data-target="#odemeModal">Borcu Öde</a>
              <?php else: ?>
                <span class="text-success">Tüm borçlarınız ödenmiş.</span>
              <?php endif; ?>
            </div>
          </div>
        </div>
        <div class="col-12 col-md-6 mb-3">
          <div class="card shadow-sm card-border">
            <div class="card-body">
              <h5 class="text-muted">Toplam Ödediğiniz</h5>
              <h2 class="font-weight-bold">₺<?= number_format($toplamOdenen, 2, ',', '.') ?></h2>
              <a href="#odemeler" class="btn btn-outline-primary mt-3">Ödeme Geçmişi</a>
            </div>
          </div>
        </div>
      </div>
      <!-- Bekleyen Aidatlar -->
      <div class="card mb-4">
        <div class="card-header card-header-warning"><h3 class="card-title">Bekleyen Aidatlar</h3></div>
        <div class="card-body table-responsive p-0">
          <table class="table table-striped">
            <thead>
              <tr>
                <th>#</th>
                <th>Ay</th>
                <th>Miktar</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($bekleyen_aidat)): ?>
                <tr><td colspan="3" class="text-center">Bekleyen aidat yok.</td></tr>
              <?php else: ?>
                <?php foreach ($bekleyen_aidat as $k => $b): ?>
                  <tr>
                    <td><?= $k + 1 ?></td>
                    <td><?= htmlspecialchars($b['ay']) ?></td>
                    <td>₺<?= number_format($b['miktar'], 2, ',', '.') ?></td>
                  </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
      <!-- Bekleyen Demirbaş Borçları -->
      <?php if (!empty($bekleyen_demirbas)): ?>
      <div class="card mb-4">
        <div class="card-header card-header-warning"><h3 class="card-title">Bekleyen Demirbaş Borçları</h3></div>
        <div class="card-body table-responsive p-0">
          <table class="table table-striped">
            <thead>
              <tr>
                <th>#</th>
                <th>Demirbaş Adı</th>
                <th>Miktar</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($bekleyen_demirbas as $k => $db): ?>
                <tr>
                  <td><?= $k + 1 ?></td>
                  <td><?= htmlspecialchars($db['demirbas_ad']) ?></td>
                  <td>₺<?= number_format($db['tutar'], 2, ',', '.') ?></td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
      <?php endif; ?>
      <!-- Ödenmiş Aidatlar & Makbuzlar -->
      <div class="card mb-5" id="odemeler">
        <div class="card-header card-header-warning"><h3 class="card-title">Ödenmiş Aidatlar & Makbuzlar</h3></div>
        <div class="card-body table-responsive p-0">
          <table class="table table-striped">
            <thead>
              <tr>
                <th>#</th>
                <th>Tarih</th>
                <th>Açıklama</th>
                <th>Miktar</th>
                <th>Makbuz No</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($odenmis)): ?>
                <tr><td colspan="5" class="text-center">Ödeme kaydı yok.</td></tr>
              <?php else: ?>
                <?php foreach ($odenmis as $k => $o): ?>
                  <tr>
                    <td><?= $k + 1 ?></td>
                    <td><?= date('d.m.Y', strtotime($o['tarih'])) ?></td>
                    <td><?= htmlspecialchars($o['aciklama'] ?? '-') ?></td>
                    <td>₺<?= number_format($o['miktar'], 2, ',', '.') ?></td>
                    <td>
                      <?php if (!empty($o['makbuz_no'])): ?>
                        <a href="makbuz_goruntule_uye.php?id=<?= $o['id'] ?>"
                           target="_blank"
                           class="text-primary font-weight-bold"
                           style="text-decoration: underline;">
                          <?= htmlspecialchars($o['makbuz_no']) ?>
                        </a>
                      <?php else: ?>
                        -
                      <?php endif; ?>
                    </td>
                  </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>
<!-- ÖDEME MODAL -->
<div class="modal fade" id="odemeModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header"><h5>Borç Ödeme</h5><button class="close" data-dismiss="modal">&times;</button></div>
      <div class="modal-body text-center">
        <p>Ödeme yapmak için EFT/Havale ya da Kredi Kartı seçeneklerini kullanabilirsiniz.</p>
        <a href="eft_ode.php" class="btn btn-success btn-block mb-2">EFT / HAVALE</a>
        <a href="kredi_karti.php" class="btn btn-primary btn-block">Kredi Kartı (İyzico)</a>
      </div>
    </div>
  </div>
</div>
<?php include '../inc/footer.php'; ?>