<?php
require_once '../config/database.php';
session_start();
error_reporting(E_ALL);
ini_set("display_errors", 1);

if (isset($_SESSION['uye_id'])) {
    header("Location: dashboard.php");
    exit;
}

$hata = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $sifre = trim($_POST['sifre']);

    $stmt = $pdo->prepare("
        SELECT u.*, s.tenant_id, s.site_adi
        FROM uyeler u
        JOIN siteler s ON u.site_id = s.id
        WHERE u.email = ?
        LIMIT 1
    ");
    $stmt->execute([$email]);
    $uye = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($uye) {
        $dogru = false;

        if (password_verify($sifre, $uye['sifre'])) {
            $dogru = true;
        } elseif ($sifre === $uye['sifre']) {
            $hash = password_hash($sifre, PASSWORD_BCRYPT);
            $up = $pdo->prepare("UPDATE uyeler SET sifre=? WHERE id=?");
            $up->execute([$hash, $uye['id']]);
            $dogru = true;
        }

        if ($dogru) {
            $_SESSION['uye_id'] = $uye['id'];
            $_SESSION['site_id'] = $uye['site_id'];
            $_SESSION['tenant_id'] = $uye['tenant_id'];
            $_SESSION['ad_soyad'] = $uye['ad_soyad'];
            $_SESSION['daire_no'] = $uye['daire_no'];
            $_SESSION['borc'] = $uye['borc'];
            $_SESSION['rol'] = 'uye';

            header("Location: dashboard.php");
            exit;
        }
    }

    $hata = "E-posta veya şifre hatalı!";
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Daire Sakini Giriş</title>

    <!-- AdminLTE + Font Awesome -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    
    <!-- Poppins Font (dashboard'la aynı) -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: 'Poppins', sans-serif !important;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0;
        }
        .login-page {
            background: transparent !important;
        }
        .login-box {
            width: 100%;
            max-width: 400px;
            margin: 20px;
        }
        .login-card {
            background: #ffffff;
            border-radius: 24px;
            overflow: hidden;
            box-shadow: 0 20px 60px rgba(0,0,0,0.25);
        }
        .login-header {
            background: linear-gradient(135deg, #4c6ef5 0%, #82a0ff 100%);
            padding: 40px 20px 30px;
            text-align: center;
            color: white;
        }
        .login-header i {
            font-size: 4rem;
            margin-bottom: 15px;
            opacity: 0.9;
        }
        .login-header h3 {
            font-weight: 700;
            font-size: 1.8rem;
            margin: 0;
        }
        .login-body {
            padding: 40px 35px 45px;
        }
        .input-group {
            margin-bottom: 20px;
        }
        .form-control {
            height: 52px;
            border-radius: 14px 0 0 14px;
            border: 1px solid #e0e6ed;
            padding-left: 15px;
            font-size: 1rem;
        }
        .form-control:focus {
            border-color: #4c6ef5;
            box-shadow: 0 0 0 0.2rem rgba(76, 110, 245, 0.15);
        }
        .input-group-text {
            border-radius: 0 14px 14px 0;
            background: #f8f9fa;
            border: 1px solid #e0e6ed;
            border-left: none;
            color: #6c757d;
        }
        .btn-login {
            background: linear-gradient(135deg, #4c6ef5 0%, #82a0ff 100%);
            border: none;
            border-radius: 14px;
            height: 52px;
            font-size: 1.1rem;
            font-weight: 600;
            transition: all 0.3s;
            box-shadow: 0 8px 20px rgba(76, 110, 245, 0.3);
        }
        .btn-login:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 30px rgba(76, 110, 245, 0.4);
        }
        .alert-danger {
            border-radius: 12px;
            padding: 14px;
            font-size: 0.95rem;
            text-align: center;
        }

        /* Mobilde daha güzel olsun */
        @media (max-width: 576px) {
            .login-box {
                max-width: 360px;
                margin: 15px;
            }
            .login-header {
                padding: 35px 15px 25px;
            }
            .login-header i {
                font-size: 3.5rem;
            }
            .login-header h3 {
                font-size: 1.6rem;
            }
            .login-body {
                padding: 35px 25px;
            }
            .form-control, .btn-login {
                height: 50px;
            }
        }
    </style>
</head>
<body class="hold-transition login-page">

<div class="login-box">
    <div class="login-card">
        <!-- Header -->
        <div class="login-header">
            <i class="fas fa-building"></i>
            <h3>DAİRE SAKİNİ GİRİŞ</h3>
        </div>

        <!-- Body -->
        <div class="login-body">
            <?php if ($hata): ?>
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle mr-2"></i><?= htmlspecialchars($hata) ?>
                </div>
            <?php endif; ?>

            <form method="post">
                <div class="input-group">
                    <input type="email" name="email" class="form-control" placeholder="E-posta adresiniz" required autofocus>
                    <div class="input-group-append">
                        <div class="input-group-text"><i class="fas fa-envelope"></i></div>
                    </div>
                </div>

                <div class="input-group">
                    <input type="password" name="sifre" class="form-control" placeholder="Şifreniz" required>
                    <div class="input-group-append">
                        <div class="input-group-text"><i class="fas fa-lock"></i></div>
                    </div>
                </div>

                <button type="submit" class="btn btn-login btn-block text-white mt-4">
                    <i class="fas fa-sign-in-alt mr-2"></i> GİRİŞ YAP
                </button>
            </form>

            <div class="text-center mt-4">
                <a href="sifre_unuttum.php" class="text-muted small">Şifremi unuttum</a>
            </div>
        </div>
    </div>
</div>

</body>
</html>