<?php
require_once '../config/database.php';
session_start();

// Üye oturumu kontrolü
if (!isset($_SESSION['uye_id'])) {
    header('Location: login.php');
    exit;
}

$uye_id = (int)$_SESSION['uye_id'];

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die('Geçersiz makbuz numarası.');
}

$id = (int)$_GET['id'];

// Sadece kendi tahsilatını görebilmesi için uye_id ile filtreliyoruz
$stmt = $pdo->prepare("
    SELECT t.*, u.ad_soyad, u.blok_adi, u.daire_no, u.telefon, u.email
    FROM tahsilatlar t
    INNER JOIN uyeler u ON t.uye_id = u.id
    WHERE t.id = ? AND t.uye_id = ?
");
$stmt->execute([$id, $uye_id]);
$makbuz = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$makbuz) {
    die('Makbuz bulunamadı veya bu makbuz size ait değil.');
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Makbuz - <?= htmlspecialchars($makbuz['makbuz_no']) ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <style>
        body {
            background: #f8f9fa;
            padding: 30px 15px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .makbuz-container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .makbuz-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px;
            text-align: center;
        }
        .makbuz-header h1 {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }
        .makbuz-body {
            padding: 50px;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #eee;
            font-size: 1.1rem;
        }
        .info-label {
            font-weight: 600;
            color: #555;
        }
        .info-value {
            color: #333;
        }
        .amount {
            text-align: center;
            font-size: 3.5rem;
            font-weight: bold;
            color: #27ae60;
            margin: 50px 0;
        }
        .footer {
            text-align: center;
            padding: 30px;
            color: #777;
            font-style: italic;
        }
        .download-btn {
            display: block;
            width: 300px;
            margin: 30px auto;
            padding: 15px;
            font-size: 1.3rem;
            background: #e74c3c;
            border: none;
            color: white;
            border-radius: 10px;
            cursor: pointer;
        }
        .download-btn:hover {
            background: #c0392b;
        }
    </style>
</head>
<body>
    <div class="makbuz-container">
        <div class="makbuz-header">
            <h1>AİDAT TAHSİLAT MAKBUZU</h1>
            <h3>Makbuz No: <?= htmlspecialchars($makbuz['makbuz_no']) ?></h3>
        </div>
        <div class="makbuz-body">
            <button onclick="indirPDF()" class="btn download-btn">
                <i class="fas fa-file-pdf fa-2x"></i><br>
                PDF OLARAK İNDİR
            </button>

            <div class="info-row">
                <span class="info-label">Üye Adı Soyadı:</span>
                <span class="info-value"><?= htmlspecialchars($makbuz['ad_soyad']) ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Daire Bilgisi:</span>
                <span class="info-value">
                    <?= htmlspecialchars($makbuz['blok_adi'] ?? '') ?> Blok
                    <?= htmlspecialchars($makbuz['daire_no']) ?> No'lu Daire
                </span>
            </div>
            <div class="info-row">
                <span class="info-label">Telefon:</span>
                <span class="info-value"><?= htmlspecialchars($makbuz['telefon'] ?? '-') ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">E-posta:</span>
                <span class="info-value"><?= htmlspecialchars($makbuz['email'] ?? '-') ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Tahsilat Tarihi:</span>
                <span class="info-value"><?= date('d.m.Y', strtotime($makbuz['tarih'])) ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Açıklama:</span>
                <span class="info-value"><?= htmlspecialchars($makbuz['aciklama'] ?? 'Aidat Ödemesi') ?></span>
            </div>

            <div class="amount">
                ₺<?= number_format($makbuz['miktar'], 2, ',', '.') ?>
            </div>

            <div class="footer">
                <p>Bu makbuz sistem tarafından otomatik olarak oluşturulmuştur.</p>
                <p><strong>Teşekkür ederiz!</strong></p>
            </div>
        </div>
    </div>

    <script>
        function indirPDF() {
            const docDefinition = {
                pageSize: 'A4',
                pageMargins: [40, 60, 40, 60],
                content: [
                    { text: 'AİDAT TAHSİLAT MAKBUZU', style: 'header' },
                    { text: 'Makbuz No: <?= htmlspecialchars($makbuz['makbuz_no']) ?>', style: 'subheader' },
                    '\n',
                    { text: 'Üye Bilgileri', style: 'section' },
                    { text: 'Ad Soyad: <?= addslashes(htmlspecialchars($makbuz['ad_soyad'])) ?>' },
                    { text: 'Daire: <?= addslashes(htmlspecialchars($makbuz['blok_adi'] ?? '')) ?> Blok <?= addslashes(htmlspecialchars($makbuz['daire_no'])) ?> No' },
                    { text: 'Telefon: <?= addslashes(htmlspecialchars($makbuz['telefon'] ?? '-')) ?>' },
                    { text: 'E-posta: <?= addslashes(htmlspecialchars($makbuz['email'] ?? '-')) ?>' },
                    '\n',
                    { text: 'Tahsilat Bilgileri', style: 'section' },
                    { text: 'Tarih: <?= date('d.m.Y', strtotime($makbuz['tarih'])) ?>' },
                    { text: 'Açıklama: <?= addslashes(htmlspecialchars($makbuz['aciklama'] ?? 'Aidat Ödemesi')) ?>' },
                    '\n\n',
                    { text: '₺<?= number_format($makbuz['miktar'], 2, ',', '.') ?>', style: 'amount' },
                    '\n\n',
                    { text: 'Teşekkür ederiz!', style: 'footer' }
                ],
                styles: {
                    header: { fontSize: 24, bold: true, alignment: 'center', margin: [0, 0, 0, 20] },
                    subheader: { fontSize: 18, bold: true, alignment: 'center', margin: [0, 0, 0, 30] },
                    section: { fontSize: 16, bold: true, margin: [0, 20, 0, 10] },
                    amount: { fontSize: 40, bold: true, color: '#27ae60', alignment: 'center' },
                    footer: { fontSize: 18, alignment: 'center', italics: true }
                }
            };
            pdfMake.createPdf(docDefinition).download('makbuz_<?= htmlspecialchars($makbuz['makbuz_no']) ?>.pdf');
        }
    </script>
</body>
</html>