<?php
require_once '../config/database.php';
session_start();

// Sadece üye erişebilsin
if (!isset($_SESSION['uye_id']) || ($_SESSION['rol'] ?? '') !== 'uye') {
    header('Location: login.php');
    exit;
}

// Bugünün tarihi
$bugun = date('Y-m-d');

// Aktif teklifler
$stmt = $pdo->prepare("
    SELECT id, baslik, aciklama, banner, gecerlilik_tarihi, eklenme_tarihi 
    FROM ozel_teklifler 
    WHERE (gecerlilik_tarihi >= :bugun OR gecerlilik_tarihi IS NULL)
    ORDER BY eklenme_tarihi DESC
");
$stmt->execute([':bugun' => $bugun]);
$teklifler = $stmt->fetchAll();

// Banner yol ayarları – panel klasöründen doğru erişim (../../)
$banner_relative_path = '../admin/uploads/teklifler/';
$banner_physical_prefix = __DIR__ . '/../admin/uploads/teklifler/';
?>

<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Özel Teklifler | Üye Paneli</title>

  <?php include '../inc/header.php'; ?>

  <style>
    body { 
      font-family: 'Poppins', sans-serif; 
      background: #f1f1f1;
    }
    .teklif-card {
      border-radius: 18px;
      overflow: hidden;
      box-shadow: 0 10px 25px rgba(0,0,0,0.15);
      transition: 0.3s;
      background: #fff;
      position: relative;
    }
    .teklif-card:hover { transform: translateY(-8px); }
    .teklif-img { height: 220px; object-fit: cover; }
    .badge-son {
      position: absolute;
      top: 12px;
      left: 12px;
      padding: 6px 12px;
      font-size: 0.9rem;
      border-radius: 12px;
      z-index: 10;
    }
    .badge-gecerli {
      position: absolute;
      top: 12px;
      right: 12px;
      padding: 6px 12px;
      font-size: 0.9rem;
      border-radius: 12px;
      z-index: 10;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <?php include '../inc/sidebar.php'; ?>
  <?php include '../inc/navbar.php'; ?>

  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <h1 class="m-0 text-center"><i class="fas fa-gift text-purple"></i> Özel Teklifler</h1>
      </div>
    </div>

    <section class="content">
      <div class="container-fluid">

        <?php if (empty($teklifler)): ?>
          <div class="card text-center p-5 shadow">
            <i class="fas fa-gift fa-4x text-muted mb-3"></i>
            <h3>Şu anda aktif özel teklif bulunmuyor</h3>
            <p class="text-muted">Yeni kampanyalar eklendiğinde burada görüntülenecektir.</p>
          </div>
        <?php else: ?>

        <div class="row justify-content-center">
          <?php foreach ($teklifler as $t): 
            // Banner dosya adı çıkarımı
            $raw_banner = trim($t['banner'] ?? '');
            $banner_file = '';
            if (strpos($raw_banner, 'uploads/teklifler/') === 0) {
                $banner_file = substr($raw_banner, strlen('uploads/teklifler/'));
            } else {
                $banner_file = $raw_banner;
            }
            $banner_file = trim($banner_file);
            $banner_src = $banner_relative_path . htmlspecialchars($banner_file);
            $full_physical_path = $banner_physical_prefix . $banner_file;

            // Son 3 gün kontrolü
            $son_gunler = false;
            if ($t['gecerlilik_tarihi']) {
                $gecerlilik = strtotime($t['gecerlilik_tarihi']);
                $uc_gun_sonra = strtotime('+3 days');
                if ($gecerlilik <= $uc_gun_sonra && $gecerlilik >= time()) {
                    $son_gunler = true;
                }
            }
          ?>
            <div class="col-lg-4 col-md-6 mb-5">
              <div class="card teklif-card">

                <!-- Banner -->
                <?php if (!empty($banner_file) && file_exists($full_physical_path)): ?>
                  <div class="position-relative">
                    <img src="<?= $banner_src ?>" class="teklif-img w-100" alt="<?= htmlspecialchars($t['baslik']) ?>">
                    
                    <?php if ($son_gunler): ?>
                      <span class="badge badge-danger badge-son">Son Günler!</span>
                    <?php endif; ?>
                    
                    <?php if ($t['gecerlilik_tarihi']): ?>
                      <span class="badge badge-success badge-gecerli">
                        <?= date('d.m.Y', strtotime($t['gecerlilik_tarihi'])) ?> kadar
                      </span>
                    <?php endif; ?>
                  </div>
                <?php else: ?>
                  <div class="bg-light d-flex align-items-center justify-content-center" style="height:220px;">
                    <i class="fas fa-gift fa-5x text-purple opacity-50"></i>
                  </div>
                <?php endif; ?>

                <div class="card-body text-center">
                  <h4 class="text-primary font-weight-bold"><?= htmlspecialchars($t['baslik']) ?></h4>

                  <p class="text-muted small mb-3">
                    <i class="far fa-calendar-plus"></i> 
                    <?= date('d.m.Y', strtotime($t['eklenme_tarihi'])) ?> tarihinde eklendi
                  </p>

                  <p class="mb-0"><?= nl2br(htmlspecialchars($t['aciklama'])) ?></p>
                </div>

                <div class="card-footer bg-purple text-white text-center py-3">
                  <h5 class="mb-0"><i class="fas fa-tag mr-2"></i>Özel Teklif</h5>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
        </div>

        <?php endif; ?>

      </div>
    </section>
  </div>

</div>

<?php include '../inc/footer.php'; ?>
</body>
</html>