<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['uye_id'])) header('Location: login.php');
$uye_id = (int)$_SESSION['uye_id'];
$site_id = (int)$_SESSION['site_id'];
$basari = $hata = '';

// Güncelleme
if (isset($_POST['guncelle'])) {
    $tc = trim($_POST['tc_kimlik'] ?? '');
    $dogum = $_POST['dogum_tarihi'] ?? null;
    $telefon2 = trim($_POST['telefon2'] ?? '');
    $mail = trim($_POST['mail'] ?? '');

    $stmt = $pdo->prepare("UPDATE uyeler SET tc_kimlik = ?, dogum_tarihi = ?, telefon2 = ?, mail = ? WHERE id = ? AND site_id = ?");
    $stmt->execute([$tc, $dogum, $telefon2, $mail, $uye_id, $site_id]);
    $basari = "Profil bilgileriniz güncellendi.";
}

// Üye bilgilerini çek
$stmt = $pdo->prepare("SELECT * FROM uyeler WHERE id = ? AND site_id = ?");
$stmt->execute([$uye_id, $site_id]);
$uye = $stmt->fetch();
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Profil Bilgileri</h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php if($basari): ?><div class="alert alert-success"><?= $basari ?></div><?php endif; ?>
    <div class="card">
      <div class="card-header"><h3 class="card-title">Kişisel Bilgileriniz</h3></div>
      <div class="card-body">
        <form method="post">
          <div class="row">
            <div class="row">
  <div class="col-md-4">
    <label>TC Kimlik No</label>
    <input name="tc_kimlik" class="form-control mb-2" placeholder="TC Kimlik No" value="<?= htmlspecialchars($uye['tc_kimlik'] ?? '') ?>">
  </div>
  <div class="col-md-4">
    <label>Doğum Tarihiniz</label>
    <input name="dogum_tarihi" type="date" class="form-control mb-2" value="<?= $uye['dogum_tarihi'] ?? '' ?>">
  </div>
  <div class="col-md-4">
    <label>Telefon (Alternatif)</label>
    <input name="telefon2" class="form-control mb-2" placeholder="Telefon (Alternatif)" value="<?= htmlspecialchars($uye['telefon2'] ?? '') ?>">
  </div>
  <div class="col-md-4">
    <label>E-posta</label>
    <input name="mail" type="email" class="form-control mb-2" placeholder="E-posta" value="<?= htmlspecialchars($uye['mail'] ?? '') ?>">
  </div>
  <div class="col-md-12 text-right mt-3">
    <button name="guncelle" class="btn btn-primary btn-lg">Güncelle</button>
  </div>
</div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div></section>
</div>
<?php include '../inc/footer.php'; ?>