<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['uye_id'])) {
    header('Location: login.php');
    exit;
}
$site_id = (int)$_SESSION['site_id'];

// Sadece aktif raporları çek
$stmt = $pdo->prepare("SELECT * FROM raporlar WHERE site_id = ? AND durum = 'aktif' ORDER BY tarih DESC");
$stmt->execute([$site_id]);
$raporlar = $stmt->fetchAll();
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h1>Rapor Merkezi</h1>
    </div>
  </div>
  <section class="content">
    <div class="container-fluid">
      <?php 
      $bolum_isimleri = [
          'anket' => 'Anket Sonuçları',
          'gelir_gider' => 'Gelir Gider Raporları',
          'toplanti' => 'Toplantı Notları',
          'belge' => 'Belgeler (Faturalar, Evraklar)',
      ];
      foreach(['anket', 'gelir_gider', 'toplanti', 'belge'] as $bolum): 
          $bolum_raporlari = array_filter($raporlar, fn($r) => $r['tip'] == $bolum);
          if (!empty($bolum_raporlari)):
      ?>
        <div class="card mb-4">
          <div class="card-header bg-info text-white">
            <h3 class="card-title"><?= $bolum_isimleri[$bolum] ?? ucwords(str_replace('_', ' ', $bolum)) ?></h3>
          </div>
          <div class="card-body">
            <?php foreach($bolum_raporlari as $r): ?>
              <div class="mb-4 p-4 border rounded bg-light">
                <h5><?= htmlspecialchars($r['baslik']) ?></h5>
                <div class="anket-rapor mb-3">
                  <?= $r['icerik'] ?> <!-- Temiz HTML doğrudan render edilir -->
                </div>
                <?php if($r['dosya']): ?>
                  <a href="<?= htmlspecialchars($r['dosya']) ?>" target="_blank" class="btn btn-sm btn-success mb-2">
                    <i class="fas fa-download"></i> Dosya İndir
                  </a>
                <?php endif; ?>
                <small class="text-muted d-block">
                  Tarih: <?= date('d.m.Y H:i', strtotime($r['tarih'])) ?>
                </small>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      <?php 
          endif;
      endforeach; 
      ?>
      <?php if (empty($raporlar)): ?>
        <div class="alert alert-info">Henüz aktif rapor bulunmamaktadır.</div>
      <?php endif; ?>
    </div>
  </section>
</div>

<style>
.anket-rapor ul {
  margin: 10px 0 15px 20px;
  padding-left: 0;
}
.anket-rapor li {
  margin-bottom: 8px;
  list-style-type: disc;
}
</style>

<?php include '../inc/footer.php'; ?>