<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['uye_id'])) header('Location: login.php');
$site_id = (int)$_SESSION['site_id'];

// Bilgileri Çek
$stmt = $pdo->prepare("SELECT * FROM site_profil WHERE site_id = ?");
$stmt->execute([$site_id]);
$profil = $stmt->fetch() ?: [];
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Site Profil Bilgileri</h1></div></div>
  <section class="content"><div class="container-fluid">
    <div class="card card-secondary">
      <div class="card-header"><h3 class="card-title">Yönetim ve İletişim Bilgileri</h3></div>
      <div class="card-body">
        <p><strong>Yönetici Adı Soyadı:</strong> <?= htmlspecialchars($profil['yonetici_ad_soyad'] ?? '-') ?></p>
        <p><strong>Telefon:</strong> <?= htmlspecialchars($profil['yonetici_telefon'] ?? '-') ?></p>
        <p><strong>E-posta:</strong> <?= htmlspecialchars($profil['yonetici_mail'] ?? '-') ?></p>
        <p><strong>Çalışma Saatleri:</strong> <?= nl2br(htmlspecialchars($profil['calisma_saatleri'] ?? '-')) ?></p>
        <p><strong>İletişim Bilgileri:</strong> <?= nl2br(htmlspecialchars($profil['iletisim_bilgileri'] ?? '-')) ?></p>
        <p><strong>Çalışan Bilgileri:</strong> <?= nl2br(htmlspecialchars($profil['calisan_bilgileri'] ?? '-')) ?></p>
      </div>
    </div>
  </div></section>
</div>
<?php include '../inc/footer.php'; ?>