<?php
require_once '../config/database.php';
session_start();

// SADECE ALT KULLANICI
if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'alt_kullanici') {
    header('Location: login.php');
    exit;
}

$site_adi = $_SESSION['site_adi'] ?? 'Site';
$yetkiler = $_SESSION['yetkiler'] ?? [];
?>

<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>

<div class="content-wrapper pb-5">
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0 text-center text-lg-left">
        <i class="fas fa-layer-group text-primary"></i>
        <?= htmlspecialchars($site_adi) ?> · Alt Kullanıcı Paneli
      </h1>
      <p class="text-muted mt-1">
        Yetkilerinize göre erişebileceğiniz modüller aşağıda listelenmiştir.
      </p>
    </div>
  </div>

  <section class="content">
    <div class="container-fluid">
      <div class="row">

        <?php
        // MODÜL TANIMLARI (sidebar ile birebir)
        $moduller = [
          'uye_kayit' => ['Üye Kayıt','uye_kayit.php','fas fa-user-plus','bg-primary'],
          'uye_detay' => ['Üye Detay','uye_detay.php','fas fa-users','bg-info'],
          'aidat_yonetimi' => ['Aidat Yönetimi','aidat_yonetimi.php','fas fa-file-invoice-dollar','bg-warning'],
          'gelir_gider' => ['Gelir - Gider','gelir_gider.php','fas fa-right-left','bg-success'],
          'demirbaslar' => ['Demirbaşlar','demirbaslar.php','fas fa-boxes-stacked','bg-secondary'],
          'grup_odeme' => ['Grup Ödeme','ozel_grup.php','fas fa-user-group','bg-info'],
          'tahsilat' => ['Tahsilat','tahsilat.php','fas fa-money-check-dollar','bg-success'],
          'toplu_sms' => ['Toplu SMS','toplu_sms.php','fas fa-comment-sms','bg-warning'],
          'whatsapp' => ['Whatsapp','whatsapp.php','fab fa-whatsapp','bg-success'],
          'anket' => ['Anket','anket.php','fas fa-square-poll-vertical','bg-danger'],
          'duyuru' => ['Duyuru','duyuru.php','fas fa-bullhorn','bg-info'],
          'toplanti' => ['Toplantı','toplanti_salonu.php','fas fa-calendar-check','bg-primary'],
          'banka_hesabi' => ['Banka Hesabı','banka_hesap.php','fas fa-building-columns','bg-secondary'],
          'raporlar' => ['Raporlar','rapor_merkezi.php','fas fa-chart-line','bg-dark'],
          'butce' => ['Bütçe','butce_hesap.php','fas fa-calculator','bg-warning'],
          'destek' => ['Destek','site_destek.php','fas fa-headset','bg-info'],
          'icra_takibi' => ['İcra Takibi','icra_takip.php','fas fa-gavel','bg-danger'],
          'anlasmali_firmalar' => ['Anlaşmalı Firmalar','anlasmali_firmalar.php','fas fa-handshake-simple','bg-primary'],
          'ozel_teklifler' => ['Özel Teklifler','ozel_teklifler.php','fas fa-gift','bg-warning'],
          'guvenlik' => ['Güvenlik','guvenlik_takip.php','fas fa-shield-halved','bg-dark'],
          'sayac' => ['Sayaç','sayac_okuma.php','fas fa-gauge','bg-info'],
          'plaka' => ['Plaka','plaka_sorgu.php','fas fa-car-side','bg-secondary'],
          'hatirlatmalar' => ['Hatırlatmalar','hatirlatmalar.php','fas fa-bell','bg-warning'],
          'calisanlar' => ['Çalışanlar','calisan_bilgi.php','fas fa-user-tie','bg-primary'],
        ];

        $gosterildi = false;

        foreach ($moduller as $key => [$baslik,$link,$icon,$bg]) {
            if (in_array($key, $yetkiler)) {
                $gosterildi = true;
        ?>
          <div class="col-lg-3 col-md-4 col-6 mb-3">
            <a href="<?= $link ?>" class="text-decoration-none">
              <div class="small-box <?= $bg ?>">
                <div class="inner text-center">
                  <h5 class="mb-1"><?= $baslik ?></h5>
                </div>
                <div class="icon">
                  <i class="<?= $icon ?>"></i>
                </div>
              </div>
            </a>
          </div>
        <?php
            }
        }

        if (!$gosterildi):
        ?>
          <div class="col-12">
            <div class="alert alert-info text-center">
              Size atanmış herhangi bir modül yetkisi bulunmamaktadır.
            </div>
          </div>
        <?php endif; ?>

      </div>
    </div>
  </section>
</div>

<style>
@media (max-width: 767.98px) {
  .small-box h5 { font-size: 0.95rem; }
  .small-box .icon { font-size: 2.5rem; top: 8px; }
}
</style>

<?php include '../inc/footer.php'; ?>
