<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) header('Location: login.php');
$site_id = (int)$_SESSION['site_id'];
$basari = $hata = '';

// TAM YETKİ LİSTESİ (Tüm modüller)
$yetkiler_liste = [
    'kontrol_paneli' => 'Kontrol Paneli',
    'alt_kullanici' => 'Alt Kullanıcı',
    'uye_kayit' => 'Üye Kayıt',
    'uye_detay' => 'Üye Detay',
    'aidat_yonetimi' => 'Aidat Yönetimi',
    'gelir_gider' => 'Gelir - Gider',
    'demirbaslar' => 'Demirbaşlar',
    'grup_odeme' => 'Grup Ödeme',
    'tahsilat' => 'Tahsilat',
    'toplu_sms' => 'Toplu SMS',
    'whatsapp' => 'Whatsapp',
    'anket' => 'Anket',
    'duyuru' => 'Duyuru',
    'toplanti' => 'Toplantı',
    'banka_hesabi' => 'Banka Hesabı',
    'raporlar' => 'Raporlar',
    'butce' => 'Bütçe',
    'destek' => 'Destek',
    'icra_takibi' => 'İcra Takibi',
    'anlasmali_firmalar' => 'Anlaşmalı Firmalar',
    'ozel_teklifler' => 'Özel Teklifler',
    'guvenlik' => 'Güvenlik',
    'sayac' => 'Sayaç',
    'plaka' => 'Plaka',
    'hatirlatmalar' => 'Hatırlatmalar',
    'calisanlar' => 'Çalışanlar'
];

// EKLEME
if (isset($_POST['ekle'])) {
    $ad_soyad = trim($_POST['ad_soyad']);
    $telefon = trim($_POST['telefon']);
    $mail = trim($_POST['mail']);
    $sifre = trim($_POST['sifre']); // Hashlenmiyor, düz metin
    $yetki = isset($_POST['yetki']) ? serialize($_POST['yetki']) : serialize([]);
    
    try {
        $stmt = $pdo->prepare("INSERT INTO alt_kullanicilar
            (site_id, ad_soyad, email, sifre, telefon, yetkiler)
            VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$site_id, $ad_soyad, $mail, $sifre, $telefon, $yetki]);
        $basari = "Alt kullanıcı eklendi!";
    } catch (Exception $e) {
        $hata = "Hata: " . $e->getMessage();
    }
}

// DÜZENLEME (GET ile veri çek)
$duzenle = null;
if (isset($_GET['duzenle']) && is_numeric($_GET['duzenle'])) {
    $stmt = $pdo->prepare("SELECT * FROM alt_kullanicilar WHERE id = ? AND site_id = ?");
    $stmt->execute([$_GET['duzenle'], $site_id]);
    $duzenle = $stmt->fetch();
}

// DÜZENLEME (POST ile kaydet)
if (isset($_POST['guncelle'])) {
    $ad_soyad = trim($_POST['ad_soyad']);
    $telefon = trim($_POST['telefon']);
    $mail = trim($_POST['mail']);
    $yetki = isset($_POST['yetki']) ? serialize($_POST['yetki']) : serialize([]);
    
    $sifre_sql = '';
    $params = [$ad_soyad, $mail, $telefon, $yetki, $_POST['id'], $site_id];
    
    if (!empty($_POST['sifre'])) {
        $sifre = trim($_POST['sifre']); // Düz metin kaydediliyor
        $sifre_sql = ", sifre = ?";
        array_splice($params, 4, 0, $sifre);
    }
    
    try {
        $stmt = $pdo->prepare("UPDATE alt_kullanicilar SET ad_soyad = ?, email = ?, telefon = ?, yetkiler = ? $sifre_sql WHERE id = ? AND site_id = ?");
        $stmt->execute($params);
        $basari = "Alt kullanıcı güncellendi!";
    } catch (Exception $e) {
        $hata = "Hata: " . $e->getMessage();
    }
}

// SİL
if (isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $pdo->prepare("DELETE FROM alt_kullanicilar WHERE id=? AND site_id=?")->execute([(int)$_GET['sil'], $site_id]);
    $basari = "Alt kullanıcı silindi!";
}

// LİSTE
$kullanicilar = $pdo->prepare("SELECT * FROM alt_kullanicilar WHERE site_id = ? ORDER BY id DESC");
$kullanicilar->execute([$site_id]);
$kullanicilar = $kullanicilar->fetchAll();
?>

<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>

<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h1><i class="fas fa-users-cog"></i> Alt Kullanıcı Yönetimi</h1>
    </div>
  </div>
  <section class="content">
    <div class="container-fluid">
      <?php if($basari): ?><div class="alert alert-success alert-dismissible"><button type="button" class="close" data-dismiss="alert">×</button><?= htmlspecialchars($basari) ?></div><?php endif; ?>
      <?php if($hata): ?><div class="alert alert-danger alert-dismissible"><button type="button" class="close" data-dismiss="alert">×</button><?= htmlspecialchars($hata) ?></div><?php endif; ?>
     
      <!-- EKLE / DÜZENLE FORMU -->
      <div class="card card-primary mb-4 shadow">
        <div class="card-header bg-gradient-primary">
          <h3 class="card-title"><?= $duzenle ? 'Alt Kullanıcı Düzenle' : 'Yeni Alt Kullanıcı Ekle' ?></h3>
        </div>
        <div class="card-body">
          <form method="post">
            <?php if($duzenle): ?><input type="hidden" name="id" value="<?= $duzenle['id'] ?>"><?php endif; ?>
            <div class="row">
              <div class="col-md-4">
                <label>Ad Soyad</label>
                <input name="ad_soyad" class="form-control" value="<?= htmlspecialchars($duzenle['ad_soyad'] ?? '') ?>" required>
              </div>
              <div class="col-md-4">
                <label>E-posta</label>
                <input name="mail" type="email" class="form-control" value="<?= htmlspecialchars($duzenle['email'] ?? '') ?>" required>
              </div>
              <div class="col-md-4">
                <label>Telefon</label>
                <input name="telefon" class="form-control" value="<?= htmlspecialchars($duzenle['telefon'] ?? '') ?>">
              </div>
            </div>
            <div class="row mt-3">
              <div class="col-md-4">
                <label>Şifre <?= $duzenle ? '(Boş bırakılırsa değişmez)' : '' ?></label>
                <input name="sifre" type="password" class="form-control" <?= $duzenle ? '' : 'required' ?>>
                <?php if (!$duzenle): ?><small class="text-muted">Belirleyeceğiniz şifre en az 6 karakterden oluşmalıdır.</small><?php endif; ?>
              </div>
            </div>
            <hr>
            <label><strong>Yetkiler</strong></label>
            <div class="row">
              <?php
              $secili_yetkiler = $duzenle ? unserialize($duzenle['yetkiler']) : [];
              foreach($yetkiler_liste as $kod => $ad):
              ?>
              <div class="col-md-4">
                <div class="form-check">
                  <input class="form-check-input" type="checkbox" name="yetki[]" value="<?= $kod ?>" <?= in_array($kod, $secili_yetkiler) ? 'checked' : '' ?>>
                  <label class="form-check-label"><?= $ad ?></label>
                </div>
              </div>
              <?php endforeach; ?>
            </div>
            <div class="text-right mt-4">
              <button name="<?= $duzenle ? 'guncelle' : 'ekle' ?>" class="btn btn-success btn-lg"><?= $duzenle ? 'Güncelle' : 'Ekle' ?></button>
              <?php if($duzenle): ?><a href="alt_kullanicilar.php" class="btn btn-secondary btn-lg ml-2">İptal</a><?php endif; ?>
            </div>
          </form>
        </div>
      </div>

      <!-- LİSTE -->
      <div class="card shadow">
        <div class="card-header bg-gradient-primary">
          <h3 class="card-title text-white">Alt Kullanıcı Listesi</h3>
        </div>
        <div class="card-body table-responsive p-0">
          <table class="table table-hover">
            <thead>
              <tr>
                <th>Ad Soyad</th>
                <th>E-posta</th>
                <th>Telefon</th>
                <th>Şifre</th>
                <th>Yetkiler</th>
                <th>İşlem</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach($kullanicilar as $k):
                $yetkiler = unserialize($k['yetkiler'] ?? serialize([]));
                $yetki_adlari = [];
                foreach($yetkiler as $y) {
                    if (isset($yetkiler_liste[$y])) $yetki_adlari[] = $yetkiler_liste[$y];
                }
              ?>
              <tr>
                <td><?= htmlspecialchars($k['ad_soyad']) ?></td>
                <td><?= htmlspecialchars($k['email']) ?></td>
                <td><?= htmlspecialchars($k['telefon']) ?></td>
                <td><code>******</code></td>
                <td><?= implode(', ', $yetki_adlari) ?: '<em>Tüm yetkiler kapalı</em>' ?></td>
                <td>
                  <a href="?duzenle=<?= $k['id'] ?>" class="btn btn-warning btn-sm"><i class="fas fa-edit"></i></a>
                  <a href="?sil=<?= $k['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Silinsin mi?')"><i class="fas fa-trash"></i></a>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>

<?php include '../inc/footer.php'; ?>