<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) header('Location: login.php');
$site_id = (int)$_SESSION['site_id'];

// Sadece aktif firmalar
$stmt = $pdo->prepare("SELECT * FROM anlasmali_firmalar WHERE aktif = 1 ORDER BY sira ASC, id DESC");
$stmt->execute();
$firmalar = $stmt->fetchAll();

// Banner göreli yol (tarayıcı için) ve fiziksel yol ön eki
$banner_relative_path = '../admin/uploads/firmalar/';
$banner_physical_prefix = __DIR__ . '/../admin/uploads/firmalar/';
?>

<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>

<div class="content-wrapper">
  <section class="content">
    <div class="container-fluid">
      <div class="row justify-content-center">
        <?php if (empty($firmalar)): ?>
          <div class="col-12">
            <div class="alert alert-info text-center">Henüz anlaşmalı firma eklenmemiş.</div>
          </div>
        <?php else: ?>
          <?php foreach ($firmalar as $f): ?>
            <div class="col-lg-4 col-md-6 mb-5">
              <div class="card shadow-lg border-0 rounded-lg overflow-hidden h-100 d-flex flex-column">
                
                <!-- Banner Bölümü -->
                <div class="position-relative">
                  <?php 
                  $raw_banner = trim($f['banner_url'] ?? '');

                  // Veritabanındaki ön eki kaldır (uploads/firmalar/ ile başlıyorsa)
                  if (strpos($raw_banner, 'uploads/firmalar/') === 0) {
                      $banner_file = substr($raw_banner, strlen('uploads/firmalar/'));
                  } else {
                      $banner_file = $raw_banner; // Nadir durum için
                  }

                  // Boşlukları temizle ve dosya adını güvenli hale getir
                  $banner_file = trim($banner_file);

                  // Sunucu kontrolü için tam fiziksel yol
                  $full_physical_path = $banner_physical_prefix . $banner_file;

                  if (!empty($banner_file) && file_exists($full_physical_path)): 
                  ?>
                    <img src="<?= $banner_relative_path . htmlspecialchars($banner_file) ?>" 
                         class="w-100" 
                         alt="<?= htmlspecialchars($f['baslik'] ?: $f['firma_adi']) ?>" 
                         style="height:250px; object-fit:contain; background:#f8f9fa;">
                  <?php else: ?>
                    <div class="bg-light d-flex align-items-center justify-content-center w-100" style="height:250px;">
                      <i class="fas fa-building fa-5x text-muted"></i>
                    </div>
                  <?php endif; ?>
                </div>

                <!-- İçerik Bölümü -->
                <div class="card-body p-4 d-flex flex-column flex-grow-1 text-center">
                  <?php if (!empty($f['baslik'])): ?>
                    <h4 class="card-title text-primary font-weight-bold mb-3">
                      <?= htmlspecialchars($f['baslik']) ?>
                    </h4>
                  <?php endif; ?>

                  <p class="card-text text-muted flex-grow-1">
                    <?= nl2br(htmlspecialchars($f['aciklama'] ?? '')) ?>
                  </p>

                  <a href="<?= htmlspecialchars($f['web_site'] ?: '#') ?>" 
                     target="_blank" 
                     class="btn btn-primary btn-lg mt-auto px-5 shadow-sm">
                    <i class="fas fa-external-link-alt mr-2"></i> Web Sitesini Ziyaret Et
                  </a>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    </div>
  </section>
</div>

<?php include '../inc/footer.php'; ?>