<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) header('Location: login.php');
$site_id = (int)$_SESSION['site_id'];
$basari = $hata = '';

// HESAP EKLE
if (isset($_POST['ekle'])) {
    $stmt = $pdo->prepare("INSERT INTO banka_hesaplari (site_id, banka_adi, sube, hesap_sahibi, iban, hesap_turu) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->execute([$site_id, $_POST['banka_adi'], $_POST['sube'], $_POST['hesap_sahibi'], $_POST['iban'], $_POST['hesap_turu']]);
    $basari = "Hesap eklendi!";
    header('Location: banka_hesap.php');
    exit;
}

// HESAP DÜZENLE (GET ile veri çek)
$duzenle = null;
if (isset($_GET['duzenle']) && is_numeric($_GET['duzenle'])) {
    $stmt = $pdo->prepare("SELECT * FROM banka_hesaplari WHERE id = ? AND site_id = ?");
    $stmt->execute([$_GET['duzenle'], $site_id]);
    $duzenle = $stmt->fetch();
}

// HESAP GÜNCELLE (POST)
if (isset($_POST['guncelle'])) {
    $stmt = $pdo->prepare("UPDATE banka_hesaplari SET banka_adi = ?, sube = ?, hesap_sahibi = ?, iban = ?, hesap_turu = ? WHERE id = ? AND site_id = ?");
    $stmt->execute([$_POST['banka_adi'], $_POST['sube'], $_POST['hesap_sahibi'], $_POST['iban'], $_POST['hesap_turu'], $_POST['id'], $site_id]);
    $basari = "Hesap güncellendi!";
    header('Location: banka_hesap.php');
    exit;
}

// HESAP SİL
if (isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $pdo->prepare("DELETE FROM banka_hesaplari WHERE id = ? AND site_id = ?")->execute([$_GET['sil'], $site_id]);
    $basari = "Hesap silindi!";
    header('Location: banka_hesap.php');
    exit;
}

// LİSTE
$hesaplar = $pdo->prepare("SELECT * FROM banka_hesaplari WHERE site_id = ? ORDER BY banka_adi");
$hesaplar->execute([$site_id]);
$hesaplar = $hesaplar->fetchAll();
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Banka Hesap Bilgileri</h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php if($basari): ?><div class="alert alert-success"><?= $basari ?></div><?php endif; ?>

    <!-- EKLE / DÜZENLE FORMU -->
    <div class="card card-primary mb-4">
      <div class="card-header"><h3 class="card-title"><?= $duzenle ? 'Banka Hesabı Düzenle' : 'Yeni Banka Hesabı Ekle' ?></h3></div>
      <div class="card-body">
        <form method="post">
          <?php if($duzenle): ?><input type="hidden" name="id" value="<?= $duzenle['id'] ?>"><?php endif; ?>
          <div class="row">
            <div class="col-md-3"><input name="banka_adi" class="form-control mb-2" placeholder="Banka Adı" value="<?= htmlspecialchars($duzenle['banka_adi'] ?? '') ?>" required></div>
            <div class="col-md-3"><input name="sube" class="form-control mb-2" placeholder="Şube" value="<?= htmlspecialchars($duzenle['sube'] ?? '') ?>"></div>
            <div class="col-md-3"><input name="hesap_sahibi" class="form-control mb-2" placeholder="Hesap Sahibi" value="<?= htmlspecialchars($duzenle['hesap_sahibi'] ?? '') ?>"></div>
            <div class="col-md-3"><input name="iban" class="form-control mb-2" placeholder="IBAN" value="<?= htmlspecialchars($duzenle['iban'] ?? '') ?>" required></div>
            <div class="col-md-3">
              <select name="hesap_turu" class="form-control mb-2" required>
                <option value="vadesiz" <?= ($duzenle['hesap_turu'] ?? '') == 'vadesiz' ? 'selected' : '' ?>>Vadesiz</option>
                <option value="vadeli" <?= ($duzenle['hesap_turu'] ?? '') == 'vadeli' ? 'selected' : '' ?>>Vadeli</option>
                <option value="aidat" <?= ($duzenle['hesap_turu'] ?? '') == 'aidat' ? 'selected' : '' ?>>Aidat</option>
                <option value="yardim" <?= ($duzenle['hesap_turu'] ?? '') == 'yardim' ? 'selected' : '' ?>>Yardım</option>
              </select>
            </div>
            <div class="col-md-12 text-right">
              <button name="<?= $duzenle ? 'guncelle' : 'ekle' ?>" class="btn btn-primary btn-lg"><?= $duzenle ? 'Güncelle' : 'Ekle' ?></button>
            </div>
          </div>
        </form>
      </div>
    </div>

    <!-- HESAP LİSTESİ -->
    <div class="row">
      <?php foreach($hesaplar as $h): ?>
      <div class="col-lg-6 mb-4">
        <div class="card">
          <div class="card-header bg-primary d-flex justify-content-between align-items-center">
            <h3 class="card-title mb-0"><?= htmlspecialchars($h['banka_adi']) ?></h3>
            <div>
              <a href="?duzenle=<?= $h['id'] ?>" class="btn btn-info btn-sm"><i class="fas fa-edit"></i></a>
              <a href="?sil=<?= $h['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Bu hesabı silmek istediğinize emin misiniz?')"><i class="fas fa-trash"></i></a>
            </div>
          </div>
          <div class="card-body">
            <p><strong>Şube:</strong> <?= htmlspecialchars($h['sube'] ?: '-') ?></p>
            <p><strong>Hesap Sahibi:</strong> <?= htmlspecialchars($h['hesap_sahibi'] ?: '-') ?></p>
            <p><strong>Hesap Türü:</strong> <?= ucfirst($h['hesap_turu']) ?></p>
            <div class="input-group">
              <input type="text" class="form-control" value="<?= $h['iban'] ?>" readonly>
              <div class="input-group-append">
                <span class="input-group-text" style="cursor:pointer;" onclick="navigator.clipboard.writeText('<?= $h['iban'] ?>'); alert('IBAN kopyalandı!')"><i class="fas fa-copy"></i></span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div></section>
</div>
<?php include '../inc/footer.php'; ?>