<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) {
    header('Location: login.php');
    exit;
}
$site_id = (int)$_SESSION['site_id'];

// Üyeleri ve borçlarını çek (sadece aidat + demirbaş)
$stmt = $pdo->prepare("
    SELECT
        u.id,
        u.blok_adi,
        u.daire_no,
        u.ad_soyad,
        COALESCE(SUM(a.miktar), 0) AS aidat_borcu,
        COALESCE(SUM(db.tutar), 0) AS demirbas_borcu
    FROM uyeler u
    LEFT JOIN aidatlar a ON u.id = a.uye_id AND a.odendi = 0
    LEFT JOIN demirbas_borclar db ON u.id = db.uye_id AND db.odendi = 0
    WHERE u.site_id = ?
    GROUP BY u.id
    ORDER BY u.blok_adi, u.daire_no
");
$stmt->execute([$site_id]);
$uyeler = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Borç Defteri</h1>
    </div>
  </div>
  <section class="content">
    <div class="container-fluid">
      <div class="card">
        <div class="card-header bg-danger text-white">
          <h3 class="card-title">Site Genel Borç Durumu</h3>
        </div>
        <div class="card-body table-responsive p-0">
          <table class="table table-hover table-bordered text-center">
            <thead class="bg-light">
              <tr>
                <th>Blok</th>
                <th>Daire No</th>
                <th>Ad Soyad</th>
                <th>Aidat Borcu</th>
                <th>Demirbaş Borcu</th>
                <th>Toplam Borç</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($uyeler)): ?>
                <tr><td colspan="6" class="text-center">Borç kaydı bulunmamaktadır.</td></tr>
              <?php else: ?>
                <?php
                $genel_toplam = 0;
                foreach ($uyeler as $u):
                  $toplam_borc = $u['aidat_borcu'] + $u['demirbas_borcu'];
                  $genel_toplam += $toplam_borc;
                ?>
                  <tr <?= $toplam_borc > 0 ? 'class="table-warning"' : '' ?>>
                    <td><?= htmlspecialchars($u['blok_adi'] ?: '-') ?></td>
                    <td><?= htmlspecialchars($u['daire_no']) ?></td>
                    <td><?= htmlspecialchars($u['ad_soyad']) ?></td>
                    <td>₺<?= number_format($u['aidat_borcu'], 2, ',', '.') ?></td>
                    <td>₺<?= number_format($u['demirbas_borcu'], 2, ',', '.') ?></td>
                    <td><strong>₺<?= number_format($toplam_borc, 2, ',', '.') ?></strong></td>
                  </tr>
                <?php endforeach; ?>
                <tr class="table-danger font-weight-bold">
                  <td colspan="5">GENEL TOPLAM BORÇ</td>
                  <td>₺<?= number_format($genel_toplam, 2, ',', '.') ?></td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>
<?php include '../inc/footer.php'; ?>