<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) {
    header('Location: login.php');
    exit;
}
$site_id = (int)$_SESSION['site_id'];
$calisan_id = (int)$_GET['id'] ?? 0;

if ($calisan_id <= 0) {
    die('Geçersiz çalışan ID.');
}

// Çalışan bilgilerini çek
$stmt = $pdo->prepare("SELECT * FROM calisanlar WHERE id = ? AND site_id = ?");
$stmt->execute([$calisan_id, $site_id]);
$calisan = $stmt->fetch();

if (!$calisan) {
    die('Çalışan bulunamadı.');
}

// Ay seçimi (varsayılan bu ay)
$ay = $_GET['ay'] ?? date('Y-m');
list($yil, $ay_no) = explode('-', $ay);
$ay_isim = date('F Y', strtotime($ay . '-01'));
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <title>Bordro - <?= htmlspecialchars($calisan['ad_soyad']) ?> - <?= $ay_isim ?></title>
  <style>
    body { font-family: DejaVu Sans, sans-serif; margin: 40px; }
    .bordro { width: 100%; max-width: 800px; margin: auto; border: 2px solid #333; padding: 20px; }
    h1, h2 { text-align: center; }
    table { width: 100%; border-collapse: collapse; margin: 20px 0; }
    th, td { border: 1px solid #333; padding: 10px; text-align: left; }
    th { background-color: #f0f0f0; }
    .toplam { font-weight: bold; font-size: 1.2em; }
    .imza { margin-top: 50px; text-align: right; }
  </style>
</head>
<body>
  <div class="bordro">
    <h1>AYLIK ÜCRET BORDROSU</h1>
    <h2><?= htmlspecialchars($calisan['ad_soyad']) ?> - <?= $ay_isim ?></h2>

    <table>
      <tr><th>Çalışan Bilgileri</th><th>Detay</th></tr>
      <tr><td>Ad Soyad</td><td><?= htmlspecialchars($calisan['ad_soyad']) ?></td></tr>
      <tr><td>Görev</td><td><?= htmlspecialchars($calisan['gorev'] ?? '-') ?></td></tr>
      <tr><td>TC No</td><td><?= htmlspecialchars($calisan['tc_no'] ?? '-') ?></td></tr>
      <tr><td>İş Giriş Tarihi</td><td><?= $calisan['ise_giris'] ? date('d.m.Y', strtotime($calisan['ise_giris'])) : '-' ?></td></tr>
      <tr><td>Brüt Ücret</td><td>₺<?= number_format($calisan['ucret'], 2, ',', '.') ?></td></tr>
    </table>

    <table>
      <tr><th>Kesintiler</th><th>Tutar</th></tr>
      <tr><td>SGK İşçi Payı (%14)</td><td>₺<?= number_format($calisan['ucret'] * 0.14, 2, ',', '.') ?></td></tr>
      <tr><td>İşsizlik Sigortası (%1)</td><td>₺<?= number_format($calisan['ucret'] * 0.01, 2, ',', '.') ?></td></tr>
      <tr><td>Gelir Vergisi (örnek %15)</td><td>₺<?= number_format($calisan['ucret'] * 0.15, 2, ',', '.') ?></td></tr>
      <tr class="toplam"><td>Net Ücret</td><td>₺<?= number_format($calisan['ucret'] * 0.70, 2, ',', '.') ?></td></tr>
    </table>

    <div class="imza">
      <p>İmza: ___________________________</p>
      <p>Tarih: <?= date('d.m.Y') ?></p>
    </div>

    <div class="text-center mt-4">
      <button onclick="window.print()" class="btn btn-success">Bordroyu Yazdır / PDF Olarak Kaydet</button>
      <a href="calisan_bilgi.php" class="btn btn-secondary">Geri Dön</a>
    </div>
  </div>
</body>
</html>