<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) {
    header('Location: login.php');
    exit;
}
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>

<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Aidat Hesaplama Aracı</h1>
    </div>
  </div>

  <section class="content">
    <div class="container-fluid">

      <!-- AİDAT HESAPLAMA FORMU -->
      <div class="card card-primary card-outline">
        <div class="card-header">
          <h3 class="card-title">Daire Başı Aidat Hesapla</h3>
        </div>
        <div class="card-body">
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label>Daire Sayısı</label>
                <input type="number" id="daire_sayisi" class="form-control" value="100" min="1" required>
              </div>
              <div class="form-group">
                <label>Ek Gelirler (Reklam, Kira, Faiz vb. - Toplam ₺)</label>
                <input type="number" id="ek_gelirler" class="form-control" value="0" min="0" required>
              </div>
              <div class="form-group">
                <label>Toplam Giderler (Fatura, Bakım, Tamirat vb. - ₺)</label>
                <input type="number" id="giderler" class="form-control" value="15000" min="0" required>
              </div>
              <div class="form-group">
                <label>Çalışan Giderleri (Kapıcı, Güvenlik, Temizlik vb. - ₺)</label>
                <input type="number" id="calisan_giderleri" class="form-control" value="12000" min="0" required>
              </div>

              <button onclick="hesapla()" class="btn btn-success btn-lg btn-block">
                <i class="fas fa-calculator"></i> Aidatı Hesapla
              </button>
            </div>

            <div class="col-md-6">
              <div id="sonuc" class="mt-4"></div>
            </div>
          </div>
        </div>
      </div>

      <!-- Açıklama Kutusu -->
      <div class="card card-info">
        <div class="card-header">
          <h3 class="card-title">Nasıl Hesaplanıyor?</h3>
        </div>
        <div class="card-body">
          <p><strong>Formül:</strong></p>
          <ol>
            <li>Toplam Gider = (Normal Giderler + Çalışan Giderleri)</li>
            <li>Net Gider = Toplam Gider - Ek Gelirler</li>
            <li>Daire Başı Aidat = Net Gider ÷ Daire Sayısı</li>
          </ol>
          <p class="text-muted">Bu araç sadece tahmini aidat belirlemek içindir. Gerçek uygulamada yasal zorunluluklar ve site kararları dikkate alınmalıdır.</p>
        </div>
      </div>

    </div>
  </section>
</div>

<script>
function hesapla() {
  const daireSayisi = parseFloat(document.getElementById('daire_sayisi').value);
  const ekGelirler = parseFloat(document.getElementById('ek_gelirler').value) || 0;
  const giderler = parseFloat(document.getElementById('giderler').value) || 0;
  const calisanGiderleri = parseFloat(document.getElementById('calisan_giderleri').value) || 0;

  if (isNaN(daireSayisi) || daireSayisi <= 0) {
    document.getElementById('sonuc').innerHTML = '<div class="alert alert-danger">Lütfen geçerli bir daire sayısı girin.</div>';
    return;
  }

  const toplamGider = giderler + calisanGiderleri;
  const netGider = toplamGider - ekGelirler;
  const daireBasiAidat = netGider / daireSayisi;

  let sonucHTML = `
    <div class="alert alert-success">
      <h4><strong>Hesaplama Sonucu</strong></h4>
      <hr>
      <p><strong>Toplam Gider:</strong> ₺${toplamGider.toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2})}</p>
      <p><strong>Ek Gelirler Düşüldükten Sonra Net Gider:</strong> ₺${netGider.toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2})}</p>
      <hr>
      <h3><strong>Daire Başı Önerilen Aidat: ₺${daireBasiAidat.toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2})}</strong></h3>
  `;

  if (netGider <= 0) {
    sonucHTML += `<p class="mt-3"><span class="badge badge-success badge-lg">Tebrikler! Ek gelirler giderleri karşılıyor. Aidat alınması gerekmeyebilir.</span></p>`;
  }

  sonucHTML += `</div>`;
  
  document.getElementById('sonuc').innerHTML = sonucHTML;
}
</script>

<?php include '../inc/footer.php'; ?>