<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) {
    header('Location: login.php');
    exit;
}
$site_id = (int)$_SESSION['site_id'];
$basari = '';
$hata = '';

// DÜZENLE (GET ile veri çek)
$duzenle = null;
if (isset($_GET['duzenle']) && is_numeric($_GET['duzenle'])) {
    $stmt = $pdo->prepare("SELECT * FROM calisanlar WHERE id = ? AND site_id = ?");
    $stmt->execute([$_GET['duzenle'], $site_id]);
    $duzenle = $stmt->fetch();
}

// EKLE / GÜNCELLE
if (isset($_POST['ekle']) || isset($_POST['guncelle'])) {
    $dosya = $duzenle['ozluk_dosyasi'] ?? '';
    if (!empty($_FILES['ozluk_dosyasi']['name'])) {
        if (!is_dir('uploads/ozluk')) mkdir('uploads/ozluk', 0755, true);
        $dosya = 'uploads/ozluk/' . time() . '_' . basename($_FILES['ozluk_dosyasi']['name']);
        move_uploaded_file($_FILES['ozluk_dosyasi']['tmp_name'], $dosya);
    }

    $ad_soyad = trim($_POST['ad_soyad'] ?? '');
    $tc_no = trim($_POST['tc_no'] ?? '');
    $telefon = trim($_POST['telefon'] ?? '');
    $gorev = trim($_POST['gorev'] ?? '');
    $ucret = (float)($_POST['ucret'] ?? 0);
    $ise_giris = $_POST['ise_giris'] ?? '';
    $sgk_no = trim($_POST['sgk_no'] ?? '');
    $adres = trim($_POST['adres'] ?? '');

    if ($ad_soyad === '') {
        $hata = 'Ad Soyad alanı zorunludur.';
    } else {
        try {
            if (isset($_POST['guncelle'])) {
                $calisan_id = (int)$_POST['calisan_id'];
                $stmt = $pdo->prepare("UPDATE calisanlar SET ad_soyad = ?, tc_no = ?, telefon = ?, gorev = ?, ucret = ?, ise_giris = ?, sgk_no = ?, adres = ?, ozluk_dosyasi = ? WHERE id = ? AND site_id = ?");
                $stmt->execute([$ad_soyad, $tc_no, $telefon, $gorev, $ucret, $ise_giris, $sgk_no, $adres, $dosya, $calisan_id, $site_id]);
                $basari = "Çalışan bilgileri güncellendi!";
            } else {
                $stmt = $pdo->prepare("INSERT INTO calisanlar (site_id, ad_soyad, tc_no, telefon, gorev, ucret, ise_giris, sgk_no, adres, ozluk_dosyasi) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$site_id, $ad_soyad, $tc_no, $telefon, $gorev, $ucret, $ise_giris, $sgk_no, $adres, $dosya]);
                $basari = "Çalışan eklendi!";
            }
            header('Location: calisan_bilgi.php');
            exit;
        } catch (Exception $e) {
            $hata = "Veritabanı hatası: " . $e->getMessage();
        }
    }
}

// SİL
if (isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $calisan_id = (int)$_GET['sil'];
    try {
        // Özlük dosyası varsa sil
        $stmt = $pdo->prepare("SELECT ozluk_dosyasi FROM calisanlar WHERE id = ? AND site_id = ?");
        $stmt->execute([$calisan_id, $site_id]);
        $dosya = $stmt->fetchColumn();
        if ($dosya && file_exists($dosya)) {
            unlink($dosya);
        }
        $pdo->prepare("DELETE FROM calisanlar WHERE id = ? AND site_id = ?")->execute([$calisan_id, $site_id]);
        $basari = "Çalışan silindi!";
        header('Location: calisan_bilgi.php');
        exit;
    } catch (Exception $e) {
        $hata = "Silme hatası: " . $e->getMessage();
    }
}

// LİSTE
$calisanlar = $pdo->prepare("SELECT * FROM calisanlar WHERE site_id = ? ORDER BY ad_soyad");
$calisanlar->execute([$site_id]);
$calisanlar = $calisanlar->fetchAll();
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Çalışan Bilgileri</h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php if($basari): ?><div class="alert alert-success"><?= $basari ?></div><?php endif; ?>
    <?php if($hata): ?><div class="alert alert-danger"><?= $hata ?></div><?php endif; ?>

    <!-- YENİ ÇALIŞAN EKLE / DÜZENLE -->
    <div class="card card-primary mb-4">
      <div class="card-header"><h3 class="card-title"><?= $duzenle ? 'Çalışan Düzenle' : 'Yeni Çalışan Ekle' ?></h3></div>
      <div class="card-body">
        <form method="post" enctype="multipart/form-data">
          <?php if($duzenle): ?><input type="hidden" name="calisan_id" value="<?= $duzenle['id'] ?>"><?php endif; ?>
          <div class="row">
            <div class="col-md-4"><input name="ad_soyad" class="form-control mb-2" placeholder="Ad Soyad" value="<?= htmlspecialchars($duzenle['ad_soyad'] ?? '') ?>" required></div>
            <div class="col-md-3"><input name="tc_no" class="form-control mb-2" placeholder="TC No" value="<?= htmlspecialchars($duzenle['tc_no'] ?? '') ?>"></div>
            <div class="col-md-3"><input name="telefon" class="form-control mb-2" placeholder="Telefon" value="<?= htmlspecialchars($duzenle['telefon'] ?? '') ?>"></div>
            <div class="col-md-3"><input name="gorev" class="form-control mb-2" placeholder="Görev" value="<?= htmlspecialchars($duzenle['gorev'] ?? '') ?>"></div>
            <div class="col-md-3"><input name="ucret" type="number" step="0.01" class="form-control mb-2" placeholder="Aylık Ücret" value="<?= $duzenle['ucret'] ?? '' ?>"></div>
            <div class="col-md-3"><input name="ise_giris" type="date" class="form-control mb-2" value="<?= $duzenle['ise_giris'] ?? '' ?>"></div>
            <div class="col-md-3"><input name="sgk_no" class="form-control mb-2" placeholder="SGK No" value="<?= htmlspecialchars($duzenle['sgk_no'] ?? '') ?>"></div>
            <div class="col-md-3"><textarea name="adres" class="form-control mb-2" placeholder="Adres"><?= htmlspecialchars($duzenle['adres'] ?? '') ?></textarea></div>
            <div class="col-md-4">
              <input type="file" name="ozluk_dosyasi" class="form-control mb-2">
              <?php if($duzenle && $duzenle['ozluk_dosyasi']): ?>
                <small>Mevcut dosya: <a href="<?= $duzenle['ozluk_dosyasi'] ?>" target="_blank">Görüntüle</a></small>
              <?php endif; ?>
            </div>
            <div class="col-md-12 text-right mt-2">
              <button name="<?= $duzenle ? 'guncelle' : 'ekle' ?>" class="btn btn-primary btn-lg"><?= $duzenle ? 'Güncelle' : 'Ekle' ?></button>
            </div>
          </div>
        </form>
      </div>
    </div>

    <!-- ÇALIŞAN LİSTESİ -->
    <div class="row">
      <?php if (empty($calisanlar)): ?>
        <div class="col-12"><div class="alert alert-info">Henüz çalışan eklenmemiş.</div></div>
      <?php endif; ?>
      <?php foreach($calisanlar as $c): ?>
      <div class="col-lg-4 mb-4">
        <div class="card">
          <div class="card-header bg-primary d-flex justify-content-between align-items-center">
            <h3 class="card-title mb-0"><?= htmlspecialchars($c['ad_soyad']) ?></h3>
            <div>
              <a href="?duzenle=<?= $c['id'] ?>" class="btn btn-info btn-sm"><i class="fas fa-edit"></i></a>
              <a href="?sil=<?= $c['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Bu çalışanı silmek istediğinize emin misiniz?')"><i class="fas fa-trash"></i></a>
            </div>
          </div>
          <div class="card-body">
            <p><strong>Görev:</strong> <?= htmlspecialchars($c['gorev'] ?: '-') ?></p>
            <p><strong>Aylık Ücret:</strong> ₺<?= number_format($c['ucret'], 2, ',', '.') ?></p>
            <p><strong>İş Giriş:</strong> <?= $c['ise_giris'] ? date('d.m.Y', strtotime($c['ise_giris'])) : '-' ?></p>
            <p><strong>Telefon:</strong> <?= htmlspecialchars($c['telefon'] ?: '-') ?></p>
            <div class="mt-3">
              <?php if($c['ozluk_dosyasi']): ?>
                <a href="<?= htmlspecialchars($c['ozluk_dosyasi']) ?>" target="_blank" class="btn btn-success btn-sm mr-2"><i class="fas fa-file-pdf"></i> Özlük Dosyası</a>
              <?php endif; ?>
              <a href="bordro.php?id=<?= $c['id'] ?>" class="btn btn-warning btn-sm" target="_blank"><i class="fas fa-file-invoice-dollar"></i> Bordro Oluştur</a>
            </div>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div></section>
</div>
<?php include '../inc/footer.php'; ?>