<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) header('Location: login.php');
$site_id = (int)$_SESSION['site_id'];
$yonetici_id = (int)$_SESSION['yonetici_id'] ?? 1;
$basari = $hata = '';

// DUYURU EKLE
if (isset($_POST['yayinla'])) {
    $dosya = '';
    if (!empty($_FILES['dosya']['name'])) {
        if (!is_dir('uploads/duyuru')) mkdir('uploads/duyuru', 0755, true);
        $dosya = 'uploads/duyuru/' . time() . '_' . basename($_FILES['dosya']['name']);
        move_uploaded_file($_FILES['dosya']['tmp_name'], $dosya);
    }
    $stmt = $pdo->prepare("INSERT INTO duyurular (site_id, baslik, icerik, ekleyen_id, dosya, durum) VALUES (?, ?, ?, ?, ?, 'yayinda')");
    $stmt->execute([$site_id, $_POST['baslik'], $_POST['icerik'], $yonetici_id, $dosya]);
    $basari = "Duyuru yayınlandı!";
}

// DUYURU DÜZENLE (GET ile veri çek)
$duzenle = null;
if (isset($_GET['duzenle']) && is_numeric($_GET['duzenle'])) {
    $stmt = $pdo->prepare("SELECT * FROM duyurular WHERE id = ? AND site_id = ?");
    $stmt->execute([$_GET['duzenle'], $site_id]);
    $duzenle = $stmt->fetch();
}

// DUYURU GÜNCELLE (POST)
if (isset($_POST['guncelle'])) {
    $dosya = $duzenle['dosya'] ?? '';
    if (!empty($_FILES['dosya']['name'])) {
        if ($dosya && file_exists($dosya)) unlink($dosya); // Eski dosyayı sil
        if (!is_dir('uploads/duyuru')) mkdir('uploads/duyuru', 0755, true);
        $dosya = 'uploads/duyuru/' . time() . '_' . basename($_FILES['dosya']['name']);
        move_uploaded_file($_FILES['dosya']['tmp_name'], $dosya);
    }
    $stmt = $pdo->prepare("UPDATE duyurular SET baslik = ?, icerik = ?, dosya = ?, durum = ? WHERE id = ? AND site_id = ?");
    $stmt->execute([$_POST['baslik'], $_POST['icerik'], $dosya, $_POST['durum'], $_POST['id'], $site_id]);
    $basari = "Duyuru güncellendi!";
}

// DUYURU SİL
if (isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $stmt = $pdo->prepare("SELECT dosya FROM duyurular WHERE id = ? AND site_id = ?");
    $stmt->execute([$_GET['sil'], $site_id]);
    $dosya = $stmt->fetchColumn();
    if ($dosya && file_exists($dosya)) unlink($dosya);
    $pdo->prepare("DELETE FROM duyurular WHERE id = ? AND site_id = ?")->execute([$_GET['sil'], $site_id]);
    $basari = "Duyuru silindi!";
}

// SIRALAMA (Yukarı/Aşağı)
if (isset($_GET['yukari']) || isset($_GET['asagi'])) {
    $id = (int)($_GET['yukari'] ?? $_GET['asagi']);
    $yön = isset($_GET['yukari']) ? 'up' : 'down';
    $stmt = $pdo->prepare("SELECT id, sira FROM duyurular WHERE site_id = ? ORDER BY sira ASC");
    $stmt->execute([$site_id]);
    $tum = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
    $keys = array_keys($tum);
    $current_pos = array_search($id, $keys);
    if ($current_pos !== false) {
        if ($yön == 'up' && $current_pos > 0) {
            $temp = $keys[$current_pos - 1];
            $keys[$current_pos - 1] = $id;
            $keys[$current_pos] = $temp;
        } elseif ($yön == 'down' && $current_pos < count($keys) - 1) {
            $temp = $keys[$current_pos + 1];
            $keys[$current_pos + 1] = $id;
            $keys[$current_pos] = $temp;
        }
        foreach ($keys as $sira => $duyuru_id) {
            $pdo->prepare("UPDATE duyurular SET sira = ? WHERE id = ? AND site_id = ?")->execute([$sira, $duyuru_id, $site_id]);
        }
    }
    header('Location: duyuru.php');
    exit;
}

// LİSTE (sıralamaya göre)
$duyurular = $pdo->prepare("SELECT * FROM duyurular WHERE site_id = ? ORDER BY sira ASC, yayin_tarihi DESC");
$duyurular->execute([$site_id]);
$duyurular = $duyurular->fetchAll();
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Duyuru Panosu</h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php if($basari): ?><div class="alert alert-success"><?= $basari ?></div><?php endif; ?>
    <?php if($hata): ?><div class="alert alert-danger"><?= $hata ?></div><?php endif; ?>

    <!-- EKLE / DÜZENLE FORMU -->
    <div class="card card-primary mb-4">
      <div class="card-header"><h3 class="card-title"><?= $duzenle ? 'Duyuru Düzenle' : 'Yeni Duyuru Yayınla' ?></h3></div>
      <div class="card-body">
        <form method="post" enctype="multipart/form-data">
          <?php if($duzenle): ?><input type="hidden" name="id" value="<?= $duzenle['id'] ?>"><?php endif; ?>
          <div class="form-group">
            <label>Başlık</label>
            <input name="baslik" class="form-control" value="<?= htmlspecialchars($duzenle['baslik'] ?? '') ?>" required>
          </div>
          <div class="form-group">
            <label>İçerik</label>
            <textarea name="icerik" class="form-control" rows="5" required><?= htmlspecialchars($duzenle['icerik'] ?? '') ?></textarea>
          </div>
          <div class="form-group">
            <label>Dosya Eki <?= $duzenle && $duzenle['dosya'] ? '(Mevcut: <a href="'.$duzenle['dosya'].'" target="_blank">İndir</a>)' : '' ?></label>
            <input type="file" name="dosya" class="form-control">
          </div>
          <?php if($duzenle): ?>
          <div class="form-group">
            <label>Durum</label>
            <select name="durum" class="form-control">
              <option value="yayinda" <?= $duzenle['durum']=='yayinda'?'selected':'' ?>>Yayında</option>
              <option value="taslak" <?= $duzenle['durum']=='taslak'?'selected':'' ?>>Taslak</option>
            </select>
          </div>
          <?php endif; ?>
          <div class="text-right">
            <button name="<?= $duzenle ? 'guncelle' : 'yayinla' ?>" class="btn btn-primary btn-lg"><?= $duzenle ? 'Güncelle' : 'Yayınla' ?></button>
            <?php if($duzenle): ?><a href="duyuru.php" class="btn btn-secondary btn-lg ml-2">İptal</a><?php endif; ?>
          </div>
        </form>
      </div>
    </div>

    <!-- DUYURU LİSTESİ -->
    <div class="card">
      <div class="card-header"><h3 class="card-title">Duyurular (Yönetim)</h3></div>
      <div class="card-body table-responsive p-0">
        <table class="table table-hover">
          <thead>
            <tr>
              <th>Sıra</th>
              <th>Başlık</th>
              <th>Yayın Tarihi</th>
              <th>Durum</th>
              <th>Dosya</th>
              <th>İşlemler</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($duyurular as $i => $d): ?>
            <tr>
              <td>
                <?php if($i > 0): ?><a href="?yukari=<?= $d['id'] ?>" class="btn btn-sm btn-info"><i class="fas fa-arrow-up"></i></a><?php endif; ?>
                <?php if($i < count($duyurular)-1): ?><a href="?asagi=<?= $d['id'] ?>" class="btn btn-sm btn-info"><i class="fas fa-arrow-down"></i></a><?php endif; ?>
              </td>
              <td><?= htmlspecialchars($d['baslik']) ?></td>
              <td><?= date('d.m.Y H:i', strtotime($d['yayin_tarihi'])) ?></td>
              <td><span class="badge <?= $d['durum']=='yayinda'?'bg-success':'bg-secondary' ?>"><?= $d['durum']=='yayinda'?'Yayında':'Taslak' ?></span></td>
              <td><?= $d['dosya'] ? '<a href="'.$d['dosya'].'" target="_blank"><i class="fas fa-download"></i></a>' : '-' ?></td>
              <td>
                <a href="?duzenle=<?= $d['id'] ?>" class="btn btn-info btn-sm"><i class="fas fa-edit"></i></a>
                <a href="?sil=<?= $d['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Silinsin mi?')"><i class="fas fa-trash"></i></a>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div></section>
</div>
<?php include '../inc/footer.php'; ?>