<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) header('Location: login.php');
$site_id = (int)$_SESSION['site_id'];
$yonetici_id = (int)$_SESSION['yonetici_id'] ?? 1;
$basari = $hata = '';

// EKLE
if (isset($_POST['ekle'])) {
    $stmt = $pdo->prepare("INSERT INTO hatirlaticilar (site_id, yonetici_id, baslik, icerik, tarih) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$site_id, $yonetici_id, $_POST['baslik'], $_POST['icerik'], $_POST['tarih']]);
    $basari = "Hatırlatma eklendi!";
}

// TAMAMLA
if (isset($_GET['tamamla']) && is_numeric($_GET['tamamla'])) {
    $pdo->prepare("UPDATE hatirlaticilar SET tamamlandi=1 WHERE id=? AND site_id=?")->execute([(int)$_GET['tamamla'], $site_id]);
    $basari = "Tamamlandı!";
}

// SİL
if (isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $pdo->prepare("DELETE FROM hatirlaticilar WHERE id=? AND site_id=?")->execute([(int)$_GET['sil'], $site_id]);
    $basari = "Hatırlatma silindi!";
}

// LİSTE
$hatirlaticilar = $pdo->prepare("SELECT * FROM hatirlaticilar WHERE site_id = ? ORDER BY tarih ASC");
$hatirlaticilar->execute([$site_id]);
$hatirlaticilar = $hatirlaticilar->fetchAll();
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Hatırlatmalar</h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php if($basari): ?><div class="alert alert-success"><?= $basari ?></div><?php endif; ?>
    <!-- YENİ HATIRLATMA -->
    <div class="card card-primary mb-4">
      <div class="card-header"><h3 class="card-title">Yeni Hatırlatma Ekle</h3></div>
      <div class="card-body">
        <form method="post">
          <div class="form-group">
            <label>Başlık</label>
            <input name="baslik" class="form-control" required>
          </div>
          <div class="form-group">
            <label>İçerik</label>
            <textarea name="icerik" сделала class="form-control" rows="3"></textarea>
          </div>
          <div class="form-group">
            <label>Tarih</label>
            <input name="tarih" type="datetime-local" class="form-control" required>
          </div>
          <div class="text-right">
            <button name="ekle" class="btn btn-primary btn-lg">Ekle</button>
          </div>
        </form>
      </div>
    </div>
    <!-- LİSTE -->
    <div class="card">
      <div class="card-header"><h3 class="card-title">Hatırlatmalar</h3></div>
      <div class="card-body table-responsive p-0">
        <table class="table table-hover">
          <thead><tr><th>Başlık</th><th>İçerik</th><th>Tarih</th><th>Durum</th><th>İşlem</th></tr></thead>
          <tbody>
            <?php foreach($hatirlaticilar as $h): ?>
            <tr>
              <td><?= htmlspecialchars($h['baslik']) ?></td>
              <td><?= htmlspecialchars($h['icerik'] ?: '-') ?></td>
              <td><?= date('d.m.Y H:i', strtotime($h['tarih'])) ?></td>
              <td><span class="badge <?= $h['tamamlandi'] ? 'bg-success' : 'bg-warning' ?>"><?= $h['tamamlandi'] ? 'Tamamlandı' : 'Bekliyor' ?></span></td>
              <td>
                <?php if(!$h['tamamlandi']): ?>
                  <a href="?tamamla=<?= $h['id'] ?>" class="btn btn-success btn-sm"><i class="fas fa-check"></i></a>
                <?php endif; ?>
                <a href="?sil=<?= $h['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Bu hatırlatmayı silmek istediğinize emin misiniz?')"><i class="fas fa-trash"></i></a>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div></section>
</div>
<?php include '../inc/footer.php'; ?>