<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) header('Location: login.php');
$site_id = (int)$_SESSION['site_id'];
$basari = $hata = '';

// EKLE
if (isset($_POST['kaydet'])) {
    $uye_id = (int)$_POST['uye_id'];
    $borc_miktari = (float)$_POST['borc_miktari'];
    $son_odeme_tarihi = $_POST['son_odeme_tarihi'];

    if ($uye_id <= 0 || $borc_miktari <= 0 || empty($son_odeme_tarihi)) {
        $hata = "Geçersiz bilgi.";
    } else {
        $stmt = $pdo->prepare("INSERT INTO icra_takip (site_id, uye_id, borc_miktari, son_odeme_tarihi, durum) VALUES (?, ?, ?, ?, 'bekliyor')");
        $stmt->execute([$site_id, $uye_id, $borc_miktari, $son_odeme_tarihi]);
        $basari = "İcra takibi başlatıldı!";
    }
}

// AVUKATA VER
if (isset($_GET['avukat']) && is_numeric($_GET['avukat'])) {
    $id = (int)$_GET['avukat'];
    $stmt = $pdo->prepare("UPDATE icra_takip SET durum = 'isleme_alindi' WHERE id = ? AND site_id = ?");
    $stmt->execute([$id, $site_id]);
    $basari = "Dosya avukata verildi!";
}

// SİL
if (isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $id = (int)$_GET['sil'];
    $stmt = $pdo->prepare("DELETE FROM icra_takip WHERE id = ? AND site_id = ?");
    $stmt->execute([$id, $site_id]);
    $basari = "Kayıt silindi!";
}

// LİSTE
$stmt = $pdo->prepare("
    SELECT i.*, u.ad_soyad, u.daire_no, u.tc_kimlik, u.dogum_tarihi, u.telefon AS uye_telefon, u.mail,
           DATEDIFF(CURDATE(), i.son_odeme_tarihi) AS geciken_gun
    FROM icra_takip i
    JOIN uyeler u ON i.uye_id = u.id
    WHERE i.site_id = ?
    ORDER BY i.durum ASC, i.son_odeme_tarihi ASC
");
$stmt->execute([$site_id]);
$takip = $stmt->fetchAll();

// Üyeler listesi (ekleme için)
$uyeler = $pdo->prepare("SELECT id, ad_soyad, daire_no FROM uyeler WHERE site_id = ? AND aktif = 1 ORDER BY daire_no");
$uyeler->execute([$site_id]);
$uyeler = $uyeler->fetchAll();
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>İcra Takibi</h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php if($basari): ?><div class="alert alert-success"><?= htmlspecialchars($basari) ?></div><?php endif; ?>
    <?php if($hata): ?><div class="alert alert-danger"><?= htmlspecialchars($hata) ?></div><?php endif; ?>

    <!-- YENİ TAKİP EKLE -->
    <div class="card card-danger mb-4">
      <div class="card-header"><h3 class="card-title">Yeni İcra Takibi Başlat</h3></div>
      <div class="card-body">
        <form method="post">
          <div class="row">
            <div class="col-md-5">
              <select name="uye_id" class="form-control mb-2" required>
                <option value="">Sakin Seçin</option>
                <?php foreach($uyeler as $u): ?>
                  <option value="<?= $u['id'] ?>"><?= htmlspecialchars($u['daire_no'] . ' - ' . $u['ad_soyad']) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-3"><input name="borc_miktari" type="number" step="0.01" class="form-control mb-2" placeholder="Borç Miktarı (TL)" required></div>
            <div class="col-md-3"><input name="son_odeme_tarihi" type="date" class="form-control mb-2" required></div>
            <div class="col-md-1 align-self-end">
              <button name="kaydet" class="btn btn-danger btn-block">Ekle</button>
            </div>
          </div>
        </form>
      </div>
    </div>

    <!-- LİSTE -->
    <div class="card">
      <div class="card-header"><h3 class="card-title">İcra Takip Listesi</h3></div>
      <div class="card-body table-responsive p-0">
        <table class="table table-hover table-bordered">
          <thead class="bg-light">
            <tr>
              <th>Sakin</th>
              <th>Daire</th>
              <th>Borç</th>
              <th>Son Ödeme</th>
              <th>Geciken Gün</th>
              <th>Kimlik Bilgileri</th>
              <th>Durum</th>
              <th>İşlem</th>
            </tr>
          </thead>
          <tbody>
            <?php if (empty($takip)): ?>
              <tr><td colspan="8" class="text-center">Kayıt bulunmamaktadır.</td></tr>
            <?php else: ?>
              <?php foreach($takip as $i): ?>
                <tr>
                  <td><?= htmlspecialchars($i['ad_soyad']) ?></td>
                  <td><?= htmlspecialchars($i['daire_no']) ?></td>
                  <td>₺<?= number_format($i['borc_miktari'], 2, ',', '.') ?></td>
                  <td><?= date('d.m.Y', strtotime($i['son_odeme_tarihi'])) ?></td>
                  <td><strong><?= max(0, $i['geciken_gun']) ?></strong></td>
                  <td>
                    TC: <?= htmlspecialchars($i['tc_kimlik'] ?? '-') ?><br>
                    Doğum: <?= $i['dogum_tarihi'] ? date('d.m.Y', strtotime($i['dogum_tarihi'])) : '-' ?><br>
                    Tel: <?= htmlspecialchars($i['uye_telefon'] ?? $i['telefon2'] ?? '-') ?><br>
                    Mail: <?= htmlspecialchars($i['mail'] ?? '-') ?>
                  </td>
                  <td>
                    <span class="badge <?= $i['durum'] == 'isleme_alindi' ? 'bg-success' : 'bg-warning' ?>">
                      <?= $i['durum'] == 'isleme_alindi' ? 'İşleme Alındı' : 'Bekliyor' ?>
                    </span>
                  </td>
                  <td>
                    <?php if ($i['durum'] == 'bekliyor'): ?>
                      <a href="?avukat=<?= $i['id'] ?>" class="btn btn-success btn-sm mr-1">Avukata Ver</a>
                    <?php endif; ?>
                    <button class="btn btn-info btn-sm mr-1" data-toggle="modal" data-target="#smsModal_<?= $i['id'] ?>">SMS Gönder</button>
                    <a href="?sil=<?= $i['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Silinsin mi?')">Sil</a>
                  </td>
                </tr>

                <!-- SMS Modal -->
                <div class="modal fade" id="smsModal_<?= $i['id'] ?>">
                  <div class="modal-dialog">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title">SMS Gönder - <?= htmlspecialchars($i['ad_soyad']) ?></h5>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                      </div>
                      <div class="modal-body">
                        <p><strong>Telefon:</strong> <?= htmlspecialchars($i['uye_telefon'] ?? $i['telefon2'] ?? 'Numara yok') ?></p>
                        <textarea class="form-control" rows="5" readonly>
Sayın <?= htmlspecialchars($i['ad_soyad']) ?>,

<?= $i['geciken_gun'] ?> gün gecikmeniz nedeniyle <?= number_format($i['borc_miktari'], 2, ',', '.') ?> TL aidat borcunuz bulunmaktadır.

Son 5 iş günü içinde ödeme yapılmadığı takdirde yasal takip süreci başlatılacaktır.

Yönetim
                        </textarea>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">İptal</button>
                        <button type="button" class="btn btn-primary" onclick="alert('SMS gönderildi! (Gerçek entegrasyon için API bağlanmalı)'); $('#smsModal_<?= $i['id'] ?>').modal('hide');">Gönder</button>
                      </div>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div></section>
</div>
<?php include '../inc/footer.php'; ?>