<?php
require_once '../config/database.php';
session_start();

// Zaten giriş yapılmışsa dashboard'a at
if (isset($_SESSION['yonetici'])) {
    header('Location: dashboard.php');
    exit;
}

$hata = '';

if ($_POST) {
    $tenant_id = trim($_POST['tenant_id'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $sifre = $_POST['sifre'] ?? '';

    if ($tenant_id && $email && $sifre) {
        // 1. ANA YÖNETİCİ KONTROLÜ (orijinal sistem)
        $stmt = $pdo->prepare("SELECT * FROM siteler WHERE tenant_id = ? AND yonetici_email = ? AND yonetici_sifre = ?");
        $stmt->execute([$tenant_id, $email, $sifre]);
        $site = $stmt->fetch();

        if ($site) {
            // Ana yönetici girişi
            $_SESSION['yonetici'] = true;
            $_SESSION['site_id'] = $site['id'];
            $_SESSION['tenant_id'] = $site['tenant_id'];
            $_SESSION['site_adi'] = $site['site_adi'];
            $_SESSION['rol'] = 'yonetici';
            header('Location: dashboard.php');
            exit;
        }

        // 2. ALT KULLANICI KONTROLÜ (yeni eklenen)
        // Önce tenant_id ile site_id bul
        $stmt_site = $pdo->prepare("SELECT id FROM siteler WHERE tenant_id = ?");
        $stmt_site->execute([$tenant_id]);
        $site_row = $stmt_site->fetch();

        if ($site_row) {
            $site_id = $site_row['id'];

            $stmt_alt = $pdo->prepare("SELECT ak.*, s.site_adi FROM alt_kullanicilar ak 
                                       LEFT JOIN siteler s ON ak.site_id = s.id 
                                       WHERE ak.site_id = ? AND ak.email = ? AND ak.sifre = ?");
            $stmt_alt->execute([$site_id, $email, $sifre]);
            $alt_kullanici = $stmt_alt->fetch();

            if ($alt_kullanici) {
                // Alt kullanıcı girişi başarılı
                $_SESSION['yonetici'] = true;
                $_SESSION['site_id'] = $alt_kullanici['site_id'];
                $_SESSION['tenant_id'] = $tenant_id;
                $_SESSION['site_adi'] = $alt_kullanici['site_adi'];
                $_SESSION['rol'] = 'alt_kullanici';
                $_SESSION['alt_kullanici_ad'] = $alt_kullanici['ad_soyad'];
                $_SESSION['yetkiler'] = unserialize($alt_kullanici['yetkiler'] ?? serialize([]));

                header('Location: dashboard.php');
                exit;
            }
        }

        // Hiçbiri uymazsa hata
        $hata = "Tenant ID, e-posta veya şifre hatalı!";
    } else {
        $hata = "Tüm alanları doldur!";
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Yönetici Giriş | YönetimOnline</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    body {font-family: 'Poppins', sans-serif; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; justify-content: center;}
    .login-box {width: 420px; max-width: 95%;}
    .card {border-radius: 20px; box-shadow: 0 20px 50px rgba(0,0,0,0.4);}
    .card-header {background: linear-gradient(135deg, #667eea, #764ba2); color: white; text-align: center; padding: 35px 20px;}
    .card-header img {width: 180px;}
    .card-header h3 {margin: 0; font-weight: 700;}
    .card-body {padding: 40px 35px;}
    .input-group .form-control {height: 52px; font-size: 16px;}
    .btn-primary {height: 52px; font-size: 18px; font-weight: 600; background: #667eea; border: none;}
    .btn-primary:hover {background: #5a6fd8;}
  </style>
</head>
<body>
<div class="login-box">
  <div class="card">
    <div class="card-header">
      <img src="../img/logo.png" alt="Logo">
      <h3>YÖNETİCİ GİRİŞİ</h3>
    </div>
    <div class="card-body">
      <?php if ($hata): ?>
        <div class="alert alert-danger text-center"><?= $hata ?></div>
      <?php endif; ?>
      <form method="post">
        <div class="input-group mb-3">
          <input type="text" name="tenant_id" class="form-control" placeholder="Tenant ID (örnek: cevizkent)" required>
          <div class="input-group-append"><div class="input-group-text"><i class="fas fa-key"></i></div></div>
        </div>
        <div class="input-group mb-3">
          <input type="email" name="email" class="form-control" placeholder="Yönetici e-posta" required>
          <div class="input-group-append"><div class="input-group-text"><i class="fas fa-envelope"></i></div></div>
        </div>
        <div class="input-group mb-4">
          <input type="password" name="sifre" class="form-control" placeholder="Şifre" required>
          <div class="input-group-append"><div class="input-group-text"><i class="fas fa-lock"></i></div></div>
        </div>
        <button type="submit" class="btn btn-primary btn-block btn-lg">GİRİŞ YAP</button>
      </form>
      <p class="text-center mt-4 text-muted">
        <small>-</small>
      </p>
    </div>
  </div>
</div>
</body>
</html>