<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) {
    header('Location: login.php');
    exit;
}

$site_id = (int)($_SESSION['site_id'] ?? 0);
$basari = '';
$hata = '';

// EKLE (PRG)
if (isset($_POST['ekle'])) {
    $tarih = $_POST['tarih'] ?? date('Y-m-d');
    $baslik = trim($_POST['baslik'] ?? '');
    $aciklama = trim($_POST['aciklama'] ?? '');
    $tutar = (float)($_POST['tutar'] ?? 0);

    if ($baslik === '' || $tutar <= 0) {
        $hata = 'Başlık ve geçerli bir tutar girilmesi zorunludur.';
    } else {
        try {
            $stmt = $pdo->prepare("INSERT INTO ozel_grup (site_id, tarih, baslik, aciklama, tutar_per_daire) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$site_id, $tarih, $baslik, $aciklama ?: null, $tutar]);
            header("Location: " . $_SERVER['PHP_SELF'] . "?ok=1");
            exit;
        } catch (Exception $e) {
            $hata = "Veritabanı hatası: " . $e->getMessage();
        }
    }
}

// ÖDEME YAP (PRG)
if (isset($_POST['odeme_yap'])) {
    $odeme_id = (int)($_POST['odeme_id'] ?? 0);
    if ($odeme_id <= 0) {
        $hata = 'Geçersiz ödeme ID.';
    } else {
        try {
            $stmt = $pdo->prepare("
                UPDATE ozel_grup_odeme
                SET odendi = 1, odeme_tarihi = NOW()
                WHERE id = ? AND grup_id IN (SELECT id FROM ozel_grup WHERE site_id = ?)
            ");
            $stmt->execute([$odeme_id, $site_id]);
            header("Location: " . $_SERVER['PHP_SELF'] . "?ok=1");
            exit;
        } catch (Exception $e) {
            $hata = "Veritabanı hatası: " . $e->getMessage();
        }
    }
}

// LISTELE
try {
    $stmt = $pdo->prepare("SELECT * FROM ozel_grup WHERE site_id = ? ORDER BY tarih DESC");
    $stmt->execute([$site_id]);
    $gruplar = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $gruplar = [];
    $hata = "Gruplar yüklenemedi: " . $e->getMessage();
}

// Her grup için istatistikleri hesapla
foreach ($gruplar as &$g) {
    $g['id'] = (int)$g['id'];
    $grup_id = $g['id'];

    // toplam üye olarak ozel_grup_odeme tablosundaki kayıt sayısını alıyoruz
    try {
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM ozel_grup_odeme WHERE grup_id = ?");
        $stmt->execute([$grup_id]);
        $g['toplam_uye'] = (int)$stmt->fetchColumn();
    } catch (Exception $e) {
        $g['toplam_uye'] = 0;
    }

    try {
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM ozel_grup_odeme WHERE grup_id = ? AND odendi = 1");
        $stmt->execute([$grup_id]);
        $g['odeyen'] = (int)$stmt->fetchColumn();
    } catch (Exception $e) {
        $g['odeyen'] = 0;
    }

    // tutar_per_daire mevcut değilse 0 al
    $tutar_per = isset($g['tutar_per_daire']) ? (float)$g['tutar_per_daire'] : 0.0;

    // hedef ve tahsil edilen toplam
    $g['toplam_tahsilat_hedef'] = $g['toplam_uye'] * $tutar_per;
    $g['tahsil_edilen_toplam'] = $g['odeyen'] * $tutar_per;

    // ödenmemiş sayısı
    $g['odemeyen'] = max(0, $g['toplam_uye'] - $g['odeyen']);
}
unset($g); // referansı temizle

?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>

<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Özel Grup Ödemeleri</h1></div></div>
  <section class="content"><div class="container-fluid">

    <?php if(!empty($_GET['ok'])): ?>
      <div class="alert alert-success">İşlem başarıyla gerçekleştirildi.</div>
    <?php endif; ?>

    <?php if($basari): ?><div class="alert alert-success"><?= htmlspecialchars($basari) ?></div><?php endif; ?>
    <?php if($hata): ?><div class="alert alert-danger"><?= htmlspecialchars($hata) ?></div><?php endif; ?>

    <!-- EKLE -->
    <div class="card card-success mb-4">
      <div class="card-header"><h3 class="card-title">Yeni Grup Ödemesi</h3></div>
      <div class="card-body">
        <form method="post">
          <div class="row">
            <div class="col-md-3"><input name="tarih" type="date" class="form-control mb-2" value="<?= date('Y-m-d') ?>" required></div>
            <div class="col-md-4"><input name="baslik" class="form-control mb-2" placeholder="Başlık" required></div>
            <div class="col-md-3"><input name="tutar" type="number" step="0.01" class="form-control mb-2" placeholder="Daire başı tutar" required></div>
            <div class="col-md-2"><input name="aciklama" class="form-control mb-2" placeholder="Açıklama"></div>
            <div class="col-md-12 text-right mt-2"><button name="ekle" class="btn btn-success btn-lg">Oluştur</button></div>
          </div>
        </form>
      </div>
    </div>

    <!-- LİSTE -->
    <div class="row">
      <?php if (empty($gruplar)): ?>
        <div class="col-12"><div class="alert alert-info">Henüz özel grup ödemesi oluşturulmamış.</div></div>
      <?php endif; ?>

      <?php foreach($gruplar as $g): ?>
      <div class="col-lg-6 mb-4">
        <div class="card">
          <div class="card-header <?= ($g['toplam_uye'] > 0 && $g['toplam_uye'] == $g['odeyen']) ? 'bg-success' : 'bg-warning' ?>">
            <h3 class="card-title"><?= htmlspecialchars($g['baslik']) ?></h3>
            <div class="card-tools"><small><?= date('d.m.Y', strtotime($g['tarih'])) ?></small></div>
          </div>

          <div class="card-body">
            <p><?= nl2br(htmlspecialchars($g['aciklama'] ?? '-')) ?></p>
            <p><strong>Daire başı:</strong> ₺<?= number_format((float)$g['tutar_per_daire'], 2, ',', '.') ?></p>
            <p><strong>Hedef tahsilat:</strong> ₺<?= number_format((float)$g['toplam_tahsilat_hedef'], 2, ',', '.') ?></p>
            <p><strong>Tahsil edilen:</strong> ₺<?= number_format((float)$g['tahsil_edilen_toplam'], 2, ',', '.') ?></p>
            <p><strong>Ödeyen:</strong> <?= (int)$g['odeyen'] ?> / <?= (int)$g['toplam_uye'] ?> daire (<?= (int)$g['odemeyen'] ?> ödemeyen)</p>

            <!-- Ödemeler listesi ve ödeme yap butonları (örnek) -->
            <div class="mt-3">
              <?php
                // küçük bir liste çekelim: (ilk 10) - isteğe göre sayfalama eklenebilir
                try {
                    $stmt = $pdo->prepare("SELECT o.id, o.uye_id, o.odendi, o.odeme_tarihi, u.ad_soyad, u.daire_no
                        FROM ozel_grup_odeme o
                        LEFT JOIN uyeler u ON u.id = o.uye_id
                        WHERE o.grup_id = ?
                        ORDER BY o.odendi ASC, u.ad_soyad ASC
                        LIMIT 200");
                    $stmt->execute([$g['id']]);
                    $odemeler = $stmt->fetchAll(PDO::FETCH_ASSOC);
                } catch (Exception $e) {
                    $odemeler = [];
                }
              ?>

              <table class="table table-sm table-bordered">
                <thead>
                  <tr><th>Daire</th><th>Ad Soyad</th><th>Durum</th><th>İşlem</th></tr>
                </thead>
                <tbody>
                <?php if (empty($odemeler)): ?>
                  <tr><td colspan="4" class="text-center text-muted">Ödeme kaydı bulunmuyor.</td></tr>
                <?php else: ?>
                  <?php foreach($odemeler as $o): ?>
                    <tr>
                      <td><?= htmlspecialchars($o['daire_no'] ?? '-') ?></td>
                      <td><?= htmlspecialchars($o['ad_soyad'] ?? '-') ?></td>
                      <td><?= $o['odendi'] ? '<span class="badge badge-success">Ödendi</span>' : '<span class="badge badge-warning">Beklemede</span>' ?></td>
                      <td>
                        <?php if (!$o['odendi']): ?>
                          <form method="post" class="d-inline">
                            <input type="hidden" name="odeme_id" value="<?= (int)$o['id'] ?>">
                            <button name="odeme_yap" class="btn btn-sm btn-primary" onclick="return confirm('Ödeme kaydı ödendi olarak işaretlensin mi?')">Öde</button>
                          </form>
                        <?php else: ?>
                          <?= date('d.m.Y H:i', strtotime($o['odeme_tarihi'])) ?>
                        <?php endif; ?>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                <?php endif; ?>
                </tbody>
              </table>
            </div>

          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>

  </div></section>
</div>

<?php include '../inc/footer.php'; ?>
