<?php
require_once '../config/database.php';

// Giriş kontrolü (panel için üye, site için herkese açık)
session_start();
if (basename(dirname(__FILE__)) === 'panel' && !isset($_SESSION['uye'])) {
    header('Location: login.php');
    exit;
}

// Sadece aktif ve geçerlilik tarihi bugünden büyük veya eşit olanlar
$bugun = date('Y-m-d');
$stmt = $pdo->prepare("SELECT * FROM ozel_teklifler WHERE gecerlilik_tarihi >= ? ORDER BY sira ASC, id DESC");
$stmt->execute([$bugun]);
$teklifler = $stmt->fetchAll();

// Banner fiziksel ve göreli yol ayarları (anlaşmalı firmalardaki gibi)
$banner_relative_path = '../admin/uploads/teklifler/';
$banner_physical_prefix = __DIR__ . '/../admin/uploads/teklifler/';
?>

<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>

<div class="content-wrapper">
  <section class="content">
    <div class="container-fluid">
      <div class="text-center my-5">
        <h1 class="display-4 text-success"><i class="fas fa-gift mr-3"></i>Özel Teklifler & Kampanyalar</h1>
        <p class="lead text-muted">Daire sakinlerimize özel indirimler ve fırsatlar</p>
      </div>
      
      <div class="row justify-content-center">
        <?php if (empty($teklifler)): ?>
          <div class="col-12">
            <div class="alert alert-info text-center">Şu anda aktif özel teklif bulunmamaktadır.</div>
          </div>
        <?php else: ?>
          <?php foreach ($teklifler as $t): ?>
            <div class="col-lg-4 col-md-6 mb-5">
              <div class="card shadow-lg border-success rounded-lg overflow-hidden h-100 d-flex flex-column position-relative">
                
                <!-- Geçerlilik Badge -->
                <div class="position-absolute" style="top:10px; right:10px; z-index:10;">
                  <span class="badge badge-pill badge-warning shadow-sm px-3 py-2">
                    <i class="fas fa-calendar-alt mr-1"></i> <?= date('d.m.Y', strtotime($t['gecerlilik_tarihi'])) ?> kadar
                  </span>
                </div>
                
                <!-- Banner Bölümü -->
                <div class="position-relative">
                  <?php 
                  $raw_banner = trim($t['banner'] ?? '');
                  if (strpos($raw_banner, 'uploads/teklifler/') === 0) {
                      $banner_file = substr($raw_banner, strlen('uploads/teklifler/'));
                  } else {
                      $banner_file = $raw_banner;
                  }
                  $banner_file = trim($banner_file);
                  $full_physical_path = $banner_physical_prefix . $banner_file;
                  
                  if (!empty($banner_file) && file_exists($full_physical_path)): 
                  ?>
                    <img src="<?= $banner_relative_path . htmlspecialchars($banner_file) ?>" 
                         class="w-100" 
                         alt="<?= htmlspecialchars($t['baslik']) ?>" 
                         style="height:250px; object-fit:contain; background:#f8f9fa;">
                  <?php else: ?>
                    <div class="bg-light d-flex align-items-center justify-content-center w-100" style="height:250px;">
                      <i class="fas fa-gift fa-5x text-success opacity-75"></i>
                    </div>
                  <?php endif; ?>
                </div>

                <!-- İçerik Bölümü -->
                <div class="card-body p-4 d-flex flex-column flex-grow-1 text-center bg-gradient-light">
                  <h4 class="card-title text-success font-weight-bold mb-3">
                    <?= htmlspecialchars($t['baslik']) ?>
                  </h4>
                  <p class="card-text text-muted flex-grow-1">
                    <?= nl2br(htmlspecialchars($t['aciklama'])) ?>
                  </p>
                </div>
                
                <!-- Alt çerçeve efekti -->
                <div class="bg-success text-white text-center py-3">
                  <h5 class="mb-0"><i class="fas fa-tag mr-2"></i>Özel Teklif</h5>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    </div>
  </section>
</div>

<?php include '../inc/footer.php'; ?>