<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) {
    header('Location: login.php');
    exit;
}
if (!isset($_SESSION['site_id'])) {
    die("site_id bulunamadı (tenant session eksik).");
}
$site_id = (int)$_SESSION['site_id'];
$basari = '';
$hata = '';

// PLAKA SORGULA / TOGGLE DURUM
if (isset($_POST['sorgula'])) {
    $plaka = strtoupper(preg_replace('/[^A-Z0-9]/', '', $_POST['plaka']));
    if ($plaka) {
        // Plaka_no'dan boşlukları vs temizleyerek sorgula
        $uyeStmt = $pdo->prepare("
            SELECT ad_soyad, daire_no, blok_adi, telefon 
            FROM uyeler 
            WHERE site_id = ? 
              AND REPLACE(UPPER(plaka_no), ' ', '') = ? 
              AND plaka_no IS NOT NULL 
              AND plaka_no != ''
            LIMIT 1
        ");
        $uyeStmt->execute([$site_id, $plaka]);
        $uye = $uyeStmt->fetch(PDO::FETCH_ASSOC);

        if (!$uye) {
            $hata = "PLAKA TANIMLI DEĞİL! Yabancı plaka içeri alınamaz.";
        } else {
            // En son kayıt durumunu kontrol et
            $kayitStmt = $pdo->prepare("
                SELECT id, durum 
                FROM plaka_kayitlari 
                WHERE site_id = ? AND plaka = ? 
                ORDER BY id DESC LIMIT 1
            ");
            $kayitStmt->execute([$site_id, $plaka]);
            $mevcutKayit = $kayitStmt->fetch(PDO::FETCH_ASSOC);

            if ($mevcutKayit && $mevcutKayit['durum'] === 'icerde') {
                $updateStmt = $pdo->prepare("UPDATE plaka_kayitlari SET cikis_tarihi = NOW(), durum = 'cikti' WHERE id = ?");
                $updateStmt->execute([$mevcutKayit['id']]);
                $basari = "Plaka çıkış yaptı: $plaka";
            } else {
                $insertStmt = $pdo->prepare("
                    INSERT INTO plaka_kayitlari 
                    (site_id, plaka, ad_soyad, daire_no, blok_adi, telefon, durum, giris_tarihi) 
                    VALUES (?, ?, ?, ?, ?, ?, 'icerde', NOW())
                ");
                $insertStmt->execute([
                    $site_id, $plaka, $uye['ad_soyad'], $uye['daire_no'], $uye['blok_adi'], $uye['telefon']
                ]);
                $basari = "Plaka giriş yaptı: $plaka";
            }
        }
    }
}

// Tanımlı plakaları çek (temizlenmiş plaka ile)
$tanimliStmt = $pdo->prepare("
    SELECT DISTINCT REPLACE(UPPER(plaka_no), ' ', '') AS plaka, ad_soyad, daire_no, blok_adi, telefon
    FROM uyeler 
    WHERE site_id = ? AND plaka_no IS NOT NULL AND plaka_no != ''
    ORDER BY blok_adi ASC, daire_no ASC, ad_soyad ASC
");
$tanimliStmt->execute([$site_id]);
$tanimliPlakalar = $tanimliStmt->fetchAll(PDO::FETCH_ASSOC);

// Her tanımlı plaka için son durumu bul
$plakaDurumlari = [];
foreach ($tanimliPlakalar as $tp) {
    $plaka = $tp['plaka'];
    $kayitStmt = $pdo->prepare("
        SELECT id, durum, giris_tarihi, cikis_tarihi 
        FROM plaka_kayitlari 
        WHERE site_id = ? AND plaka = ? 
        ORDER BY id DESC LIMIT 1
    ");
    $kayitStmt->execute([$site_id, $plaka]);
    $sonKayit = $kayitStmt->fetch(PDO::FETCH_ASSOC);

    $durum = $sonKayit ? $sonKayit['durum'] : 'cikti';
    $giris = $sonKayit ? date('d.m.Y H:i', strtotime($sonKayit['giris_tarihi'])) : '-';
    $cikis = $sonKayit && $sonKayit['cikis_tarihi'] ? date('d.m.Y H:i', strtotime($sonKayit['cikis_tarihi'])) : '-';
    $kayitId = $sonKayit ? $sonKayit['id'] : null;

    $plakaDurumlari[] = array_merge($tp, [
        'durum' => $durum,
        'giris_tarihi' => $giris,
        'cikis_tarihi' => $cikis,
        'kayit_id' => $kayitId
    ]);
}

// Sayıları hesapla
$toplamArac = count($tanimliPlakalar);
$icerdeSayi = 0;
foreach ($plakaDurumlari as $pd) {
    if ($pd['durum'] === 'icerde') $icerdeSayi++;
}
$disaridaSayi = $toplamArac - $icerdeSayi;
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Plaka Takip Sistemi</h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php if($basari): ?><div class="alert alert-success"><?= htmlspecialchars($basari) ?></div><?php endif; ?>
    <?php if($hata): ?><div class="alert alert-danger"><?= htmlspecialchars($hata) ?></div><?php endif; ?>
    <!-- HIZLI PLAKA GİRİŞİ -->
    <div class="card card-primary mb-4">
      <div class="card-header"><h3 class="card-title">Plaka Sorgula / Giriş-Çıkış Yap</h3></div>
      <div class="card-body">
        <form method="post" class="row g-3 align-items-center">
          <div class="col-md-8">
            <input type="text" name="plaka" class="form-control form-control-lg text-uppercase" placeholder="PLA KA GİR (ÖRN: 34ABC123)" required autofocus>
          </div>
          <div class="col-md-4">
            <button name="sorgula" class="btn btn-success btn-lg w-100">İŞLEM YAP</button>
          </div>
        </form>
      </div>
    </div>
    <!-- SAYI KARTLARI -->
    <div class="row mb-4">
      <div class="col-md-4">
        <div class="card bg-info text-white">
          <div class="card-body text-center">
            <h5>Toplam Araç</h5>
            <h2><?= $toplamArac ?></h2>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card bg-success text-white">
          <div class="card-body text-center">
            <h5>İçeride</h5>
            <h2><?= $icerdeSayi ?></h2>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card bg-danger text-white">
          <div class="card-body text-center">
            <h5>Dışarıda</h5>
            <h2><?= $disaridaSayi ?></h2>
          </div>
        </div>
      </div>
    </div>
    <!-- PLAKA DURUM LİSTESİ -->
    <div class="card">
      <div class="card-header"><h3 class="card-title">Tanımlı Plaka Durumları</h3></div>
      <div class="card-body table-responsive p-0">
        <table class="table table-hover">
          <thead>
            <tr>
              <th>Plaka</th>
              <th>Ad Soyad</th>
              <th>Blok / Daire</th>
              <th>Telefon</th>
              <th>Giriş</th>
              <th>Çıkış</th>
              <th>Durum</th>
              <th>İşlem</th>
            </tr>
          </thead>
          <tbody>
            <?php if (empty($plakaDurumlari)): ?>
            <tr><td colspan="8" class="text-center">Tanımlı plaka bulunmamaktadır.</td></tr>
            <?php else: ?>
            <?php foreach($plakaDurumlari as $pd): ?>
            <tr class="<?= $pd['durum']=='icerde' ? 'table-success' : 'table-danger' ?>">
              <td><strong><?= htmlspecialchars($pd['plaka']) ?></strong></td>
              <td><?= htmlspecialchars($pd['ad_soyad'] ?: '-') ?></td>
              <td><?= htmlspecialchars($pd['blok_adi'] ?: '-') ?> / <?= htmlspecialchars($pd['daire_no'] ?: '-') ?></td>
              <td><?= htmlspecialchars($pd['telefon'] ?: '-') ?></td>
              <td><?= $pd['giris_tarihi'] ?></td>
              <td><?= $pd['cikis_tarihi'] ?></td>
              <td>
                <span class="badge <?= $pd['durum']=='icerde' ? 'bg-success' : 'bg-danger' ?>">
                  <?= $pd['durum']=='icerde' ? 'İÇERİDE' : 'ÇIKTI' ?>
                </span>
              </td>
              <td>
                <?php if ($pd['durum'] == 'icerde' && $pd['kayit_id']): ?>
                  <a href="?cikis=<?= $pd['kayit_id'] ?>" class="btn btn-danger btn-sm">ÇIKIŞ YAP</a>
                <?php endif; ?>
              </td>
            </tr>
            <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div></section>
</div>
<?php include '../inc/footer.php'; ?>