<?php
require_once '../config/database.php';
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
// Oturum kontrolü
if (!isset($_SESSION['yonetici'])) {
    header('Location: login.php');
    exit;
}
$site_id = (int)$_SESSION['site_id'];
$basari = $hata = '';
// Rapor toggle (aktif/pasif)
if (isset($_GET['toggle']) && is_numeric($_GET['toggle'])) {
    $id = (int)$_GET['toggle'];
    $stmt = $pdo->prepare("SELECT durum FROM raporlar WHERE id = ? AND site_id = ?");
    $stmt->execute([$id, $site_id]);
    $mevcut = $stmt->fetchColumn();
    $yeni = $mevcut == 'aktif' ? 'pasif' : 'aktif';
    $pdo->prepare("UPDATE raporlar SET durum = ? WHERE id = ? AND site_id = ?")->execute([$yeni, $id, $site_id]);
    $basari = "Rapor durumu değiştirildi.";
    header('Location: rapor_merkezi.php');
    exit;
}
// Rapor sil
if (isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $id = (int)$_GET['sil'];
    $stmt = $pdo->prepare("SELECT dosya FROM raporlar WHERE id = ? AND site_id = ?");
    $stmt->execute([$id, $site_id]);
    $dosya = $stmt->fetchColumn();
    if ($dosya && file_exists($dosya)) {
        unlink($dosya);
    }
    $pdo->prepare("DELETE FROM raporlar WHERE id = ? AND site_id = ?")->execute([$id, $site_id]);
    $basari = "Rapor silindi.";
    header('Location: rapor_merkezi.php');
    exit;
}
if (isset($_POST['yayinla_gelir_gider'])) {

    $ay = $_POST['ay']; // 2025-12
    [$y, $m] = explode('-', $ay);

    $turkce_aylar = [
        '01'=>'Ocak','02'=>'Şubat','03'=>'Mart','04'=>'Nisan',
        '05'=>'Mayıs','06'=>'Haziran','07'=>'Temmuz','08'=>'Ağustos',
        '09'=>'Eylül','10'=>'Ekim','11'=>'Kasım','12'=>'Aralık'
    ];

    $ay_adi = $turkce_aylar[$m] . ' ' . $y;
    $baslik = $ay_adi . ' Ayı Gelir-Gider Raporu';

    // 🔒 DUPLICATE KONTROLÜ (COLLATION FIX)
    $check = $pdo->prepare("
        SELECT id FROM raporlar
        WHERE site_id = ?
          AND tip = 'gelir_gider'
          AND baslik COLLATE utf8mb4_turkish_ci = ?
    ");
    $check->execute([$site_id, $baslik]);

    if ($check->fetch()) {
        $hata = "$ay_adi ayı gelir-gider raporu zaten yayınlanmış!";
        return;
    }

    // 🔹 TARİH ARALIĞI (COLLATION YOK)
    $baslangic = "$ay-01";
    $bitis = date('Y-m-t', strtotime($baslangic));

    $stmt = $pdo->prepare("
        SELECT tarih, aciklama, tip, tutar
        FROM gelir_gider
        WHERE site_id = ?
          AND tarih BETWEEN ? AND ?
        ORDER BY tarih ASC
    ");
    $stmt->execute([$site_id, $baslangic, $bitis]);
    $veriler = $stmt->fetchAll();

    // 🔹 HTML (MOBİL UYUMLU)
    $html = '<div class="table-responsive">
    <table class="table table-bordered">
        <tr>
            <th>Tarih</th>
            <th>Açıklama</th>
            <th>Gelir</th>
            <th>Gider</th>
        </tr>';

    $toplam_gelir = 0;
    $toplam_gider = 0;

    foreach ($veriler as $v) {

        $gelir = $gider = '';

        if ($v['tip'] === 'gelir') {
            $gelir = number_format($v['tutar'], 2, ',', '.') . ' ₺';
            $toplam_gelir += $v['tutar'];
        } else {
            $gider = number_format($v['tutar'], 2, ',', '.') . ' ₺';
            $toplam_gider += $v['tutar'];
        }

        $html .= "
        <tr>
            <td>".date('d.m.Y', strtotime($v['tarih']))."</td>
            <td>".htmlspecialchars($v['aciklama'])."</td>
            <td>$gelir</td>
            <td>$gider</td>
        </tr>";
    }

    $html .= "
        <tr class='table-success'>
            <th colspan='2'>TOPLAM</th>
            <th>".number_format($toplam_gelir, 2, ',', '.')." ₺</th>
            <th>".number_format($toplam_gider, 2, ',', '.')." ₺</th>
        </tr>
    </table>
    </div>";

    $insert = $pdo->prepare("
        INSERT INTO raporlar
        (site_id, tip, baslik, icerik, dosya, tarih, durum)
        VALUES (?, 'gelir_gider', ?, ?, NULL, NOW(), 'aktif')
    ");
    $insert->execute([$site_id, $baslik, $html]);

    $basari = "$ay_adi ayı gelir-gider raporu başarıyla yayınlandı!";
}


// Toplantı yayınla - COLLATION HATASI KESİN ÇÖZÜLDÜ
if (isset($_POST['yayinla_toplanti'])) {
    $toplanti_id = (int)$_POST['toplanti_id'];
    // Kontrol sorgusu: HER İKİ TARAF DA general_ci
    $check = $pdo->prepare("
        SELECT id FROM raporlar
        WHERE site_id = ?
          AND tip = 'toplanti'
          AND baslik COLLATE utf8mb4_general_ci = (
              SELECT baslik COLLATE utf8mb4_general_ci
              FROM toplantilar
              WHERE id = ? AND site_id = ?
          )
    ");
    $check->execute([$site_id, $toplanti_id, $site_id]);
    if ($check->fetch()) {
        $hata = "Bu toplantı zaten yayınlanmış!";
    } else {
        $stmt = $pdo->prepare("SELECT * FROM toplantilar WHERE id = ? AND site_id = ?");
        $stmt->execute([$toplanti_id, $site_id]);
        $t = $stmt->fetch();
        if ($t) {
            $html = '<p><strong>Tarih:</strong> ' . date('d.m.Y', strtotime($t['tarih'])) . '</p>';
            $html .= '<p><strong>Başlık:</strong> ' . htmlspecialchars($t['baslik']) . '</p>';
            if ($t['kararlar']) $html .= '<p><strong>Kararlar:</strong><br>' . nl2br(htmlspecialchars($t['kararlar'])) . '</p>';
            if ($t['katilanlar']) $html .= '<p><strong>Katılanlar:</strong><br>' . nl2br(htmlspecialchars($t['katilanlar'])) . '</p>';
            $dosya = $t['dosya1'] ?: $t['dosya2'] ?: null;
            $insert = $pdo->prepare("INSERT INTO raporlar (site_id, tip, baslik, icerik, dosya, tarih, durum) VALUES (?, 'toplanti', ?, ?, ?, NOW(), 'aktif')");
            $insert->execute([$site_id, $t['baslik'], $html, $dosya]);
            $basari = "Toplantı notu raporda yayınlandı!";
        } else {
            $hata = "Toplantı bulunamadı veya yetkisiz erişim!";
        }
    }
}
// Belgeler ekle (değişmedi)
if (isset($_POST['belge_ekle'])) {
    $dosya = '';
    if (!empty($_FILES['belge_dosya']['name'])) {
        if (!is_dir('uploads/belgeler')) mkdir('uploads/belgeler', 0755, true);
        $dosya = 'uploads/belgeler/' . time() . '_' . basename($_FILES['belge_dosya']['name']);
        move_uploaded_file($_FILES['belge_dosya']['tmp_name'], $dosya);
    }
    $stmt = $pdo->prepare("INSERT INTO raporlar (site_id, tip, baslik, icerik, dosya, tarih, durum) VALUES (?, 'belge', ?, '', ?, NOW(), 'aktif')");
    $stmt->execute([$site_id, $_POST['belge_baslik'], $dosya]);
    $basari = "Belge rapora eklendi!";
}
// Tüm raporları çek
$stmt = $pdo->prepare("SELECT * FROM raporlar WHERE site_id = ? ORDER BY tarih DESC");
$stmt->execute([$site_id]);
$raporlar = $stmt->fetchAll();
// Aylık gelir-gider ayları
$aylik_aylar = $pdo->query("SELECT DISTINCT DATE_FORMAT(tarih, '%Y-%m') AS ay FROM gelir_gider WHERE site_id = $site_id ORDER BY ay DESC")->fetchAll(PDO::FETCH_COLUMN);
// Toplantılar
$stmt = $pdo->prepare("SELECT id, tarih, baslik FROM toplantilar WHERE site_id = ? ORDER BY tarih DESC");
$stmt->execute([$site_id]);
$toplantilar = $stmt->fetchAll();
// Türkçe ay isimleri
$turkce_aylar = [
    '01' => 'Ocak', '02' => 'Şubat', '03' => 'Mart', '04' => 'Nisan',
    '05' => 'Mayıs', '06' => 'Haziran', '07' => 'Temmuz', '08' => 'Ağustos',
    '09' => 'Eylül', '10' => 'Ekim', '11' => 'Kasım', '12' => 'Aralık'
];
// Bölüm isimleri
$bolum_isimleri = [
    'anket' => 'Anket Sonuçları',
    'gelir_gider' => 'Gelir Gider Raporları',
    'toplanti' => 'Toplantı Notları',
    'belge' => 'Belgeler (Faturalar, Evraklar)',
    'tahsilat' => 'Tahsilat Raporları',
    'guvenlik' => 'Güvenlik Kayıtları',
    'plaka' => 'Plaka Takip Raporları',
    'fatura' => 'Fatura Raporları',
    'demirbas' => 'Demirbaş Raporları',
    'bakim_ariza' => 'Bakım ve Arıza Raporları'
];
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h1>Rapor Merkezi (Yönetim)</h1>
    </div>
  </div>
  <section class="content">
    <div class="container-fluid">
      <?php if($basari): ?><div class="alert alert-success"><?= $basari ?></div><?php endif; ?>
      <?php if($hata): ?><div class="alert alert-danger"><?= $hata ?></div><?php endif; ?>
      <!-- Gelir-Gider Yayınla -->
      <div class="card mb-4">
        <div class="card-header bg-success text-white">
          <h3 class="card-title">Gelir-Gider Aylık Rapor Yayınla</h3>
        </div>
        <div class="card-body">
          <form method="post">
            <div class="row align-items-end">
              <div class="col-md-4">
                <label>Ay Seç</label>
                <select name="ay" class="form-control" required>
                  <?php if (empty($aylik_aylar)): ?>
                    <option value="">Kayıt yok</option>
                  <?php else: ?>
                    <?php foreach ($aylik_aylar as $ay):
                      list($y, $m) = explode('-', $ay);
                      $ay_adi = $turkce_aylar[$m] . ' ' . $y;
                    ?>
                      <option value="<?= $ay ?>"><?= $ay_adi ?></option>
                    <?php endforeach; ?>
                  <?php endif; ?>
                </select>
              </div>
              <div class="col-md-3">
                <button name="yayinla_gelir_gider" class="btn btn-success btn-block">Yayınla</button>
              </div>
            </div>
          </form>
        </div>
      </div>
      <!-- Toplantı Notları Yayınla -->
      <div class="card mb-4">
        <div class="card-header bg-warning text-white">
          <h3 class="card-title">Toplantı Notu Yayınla</h3>
        </div>
        <div class="card-body">
          <?php if (empty($toplantilar)): ?>
            <p>Henüz toplantı eklenmemiş.</p>
          <?php else: ?>
            <?php foreach ($toplantilar as $t): ?>
              <form method="post" class="mb-2">
                <input type="hidden" name="toplanti_id" value="<?= $t['id'] ?>">
                <div class="d-flex justify-content-between align-items-center">
                  <span><?= date('d.m.Y', strtotime($t['tarih'])) ?> - <?= htmlspecialchars($t['baslik']) ?></span>
                  <button name="yayinla_toplanti" class="btn btn-warning btn-sm">Yayınla</button>
                </div>
              </form>
            <?php endforeach; ?>
          <?php endif; ?>
        </div>
      </div>
      <!-- Belgeler Ekle -->
      <div class="card mb-4">
        <div class="card-header bg-info text-white">
          <h3 class="card-title">Belge Ekle (Faturalar, Evraklar)</h3>
        </div>
        <div class="card-body">
          <form method="post" enctype="multipart/form-data">
            <div class="row">
              <div class="col-md-6">
                <input name="belge_baslik" class="form-control mb-2" placeholder="Belge Başlığı" required>
              </div>
              <div class="col-md-4">
                <input type="file" name="belge_dosya" class="form-control mb-2" required>
              </div>
              <div class="col-md-2">
                <button name="belge_ekle" class="btn btn-info btn-block">Ekle</button>
              </div>
            </div>
          </form>
        </div>
      </div>
      <!-- Yayınlanmış Raporlar -->
      <?php
      foreach(['anket', 'gelir_gider', 'toplanti', 'belge', 'tahsilat', 'guvenlik', 'plaka', 'fatura', 'demirbas', 'bakim_ariza'] as $bolum):
          $bolum_raporlari = array_filter($raporlar, fn($r) => $r['tip'] == $bolum);
          if (!empty($bolum_raporlari)):
      ?>
          <div class="card mb-4">
            <div class="card-header bg-info text-white">
              <h3 class="card-title"><?= $bolum_isimleri[$bolum] ?? ucwords(str_replace('_', ' ', $bolum)) ?></h3>
            </div>
            <div class="card-body">
              <?php foreach($bolum_raporlari as $r): ?>
                <div class="mb-4 p-4 border rounded bg-light">
                  <h5><?= htmlspecialchars($r['baslik']) ?></h5>
                  <div class="anket-rapor mb-3">
                    <?= $r['icerik'] ?>
                  </div>
                  <?php if($r['dosya']): ?>
                    <a href="<?= htmlspecialchars($r['dosya']) ?>" target="_blank" class="btn btn-sm btn-success mb-2">
                      <i class="fas fa-download"></i> Dosya İndir
                    </a>
                  <?php endif; ?>
                  <small class="text-muted d-block">
                    Tarih: <?= date('d.m.Y H:i', strtotime($r['tarih'])) ?> | Durum:
                    <span class="badge <?= $r['durum']=='aktif' ? 'bg-success' : 'bg-secondary' ?>">
                      <?= ucfirst($r['durum']) ?>
                    </span>
                  </small>
                  <div class="mt-3">
                    <a href="?toggle=<?= $r['id'] ?>" class="btn btn-sm btn-<?= $r['durum']=='aktif'?'warning':'success' ?>">
                      <?= $r['durum']=='aktif' ? 'Pasif Yap' : 'Aktif Yap' ?>
                    </a>
                    <a href="?sil=<?= $r['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu raporu silmek istediğinize emin misiniz?')">
                      Sil
                    </a>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
          </div>
      <?php
          endif;
      endforeach;
      ?>
      <?php if (empty($raporlar)): ?>
        <div class="alert alert-info">Henüz rapor eklenmemiştir.</div>
      <?php endif; ?>
    </div>
  </section>
</div>
<style>
.anket-rapor ul {
  margin: 10px 0 15px 20px;
  padding-left: 0;
}
.anket-rapor li {
  margin-bottom: 8px;
  list-style-type: disc;
}
</style>
<?php include '../inc/footer.php'; ?>