<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) header('Location: login.php');
$site_id = (int)$_SESSION['site_id'];
$basari = $hata = '';

// MODÜL AÇ/KAPA
if (isset($_GET['modul'])) {
    $aktif = ($_GET['modul'] == 'ac') ? 1 : 0;
    $stmt = $pdo->prepare("UPDATE siteler SET destek_modul_aktif = ? WHERE id = ?");
    $stmt->execute([$aktif, $site_id]);
    $basari = "Destek modülü " . ($aktif ? 'açıldı' : 'kapatıldı') . ".";
}

// LİSTE ve PUAN ORTALAMASI
$stmt = $pdo->prepare("SELECT * FROM destek_talepleri WHERE site_id = ? ORDER BY eklenme_tarihi DESC");
$stmt->execute([$site_id]);
$talepler = $stmt->fetchAll();

// Puan ortalaması hesapla
$toplam_puan = 0;
$talep_sayisi = count($talepler);
foreach ($talepler as $t) {
    $toplam_puan += (int)$t['puan'];
}
$ortalama = $talep_sayisi > 0 ? round($toplam_puan / $talep_sayisi, 2) : 0;

// Modül durumu
$stmt = $pdo->prepare("SELECT destek_modul_aktif FROM siteler WHERE id = ?");
$stmt->execute([$site_id]);
$modul_aktif = $stmt->fetchColumn();
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Site Destek Paneli (Yönetim)</h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php if($basari): ?><div class="alert alert-success"><?= htmlspecialchars($basari) ?></div><?php endif; ?>

    <div class="row mb-4">
      <div class="col-md-6">
        <div class="info-box">
          <span class="info-box-icon bg-info"><i class="fas fa-star"></i></span>
          <div class="info-box-content">
            <span class="info-box-text">Yönetim Puan Ortalaması</span>
            <span class="info-box-number"><?= $ortalama ?> / 5</span>
          </div>
        </div>
      </div>
      <div class="col-md-6 text-right">
        <?php if ($modul_aktif): ?>
          <a href="?modul=kapat" class="btn btn-danger">Modülü Kapat</a>
        <?php else: ?>
          <a href="?modul=ac" class="btn btn-success">Modülü Aç</a>
        <?php endif; ?>
        <span class="ml-3 badge <?= $modul_aktif ? 'bg-success' : 'bg-danger' ?>">
          Modül: <?= $modul_aktif ? 'Açık' : 'Kapalı' ?>
        </span>
      </div>
    </div>

    <!-- TALEP LİSTESİ -->
    <div class="card">
      <div class="card-header"><h3 class="card-title">Gelen Öneri ve Şikayetler (Toplam: <?= $talep_sayisi ?>)</h3></div>
      <div class="card-body table-responsive p-0">
        <table class="table table-hover">
          <thead>
            <tr>
              <th>Konu</th>
              <th>Gönderen</th>
              <th>Mesaj</th>
              <th>Puan</th>
              <th>Tarih</th>
            </tr>
          </thead>
          <tbody>
            <?php if (empty($talepler)): ?>
              <tr><td colspan="5" class="text-center">Henüz talep gönderilmemiş.</td></tr>
            <?php else: ?>
              <?php foreach($talepler as $t): ?>
                <tr>
                  <td><?= htmlspecialchars($t['konu']) ?></td>
                  <td><?= htmlspecialchars($t['uye_ad_soyad']) ?></td>
                  <td><?= nl2br(htmlspecialchars($t['mesaj'])) ?></td>
                  <td><span class="badge bg-primary"><?= $t['puan'] ?></span></td>
                  <td><?= date('d.m.Y H:i', strtotime($t['eklenme_tarihi'])) ?></td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div></section>
</div>
<?php include '../inc/footer.php'; ?>