<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) {
    header('Location: login.php');
    exit;
}
$site_id = (int)$_SESSION['site_id'];
$basari = '';
$hata = '';

// Güncelleme
if (isset($_POST['guncelle'])) {
    $yonetici_ad_soyad = trim($_POST['yonetici_ad_soyad'] ?? '');
    $yonetici_telefon = trim($_POST['yonetici_telefon'] ?? '');
    $yonetici_mail = trim($_POST['yonetici_mail'] ?? '');
    $calisma_saatleri = trim($_POST['calisma_saatleri'] ?? '');
    $iletisim_bilgileri = trim($_POST['iletisim_bilgileri'] ?? '');
    $calisan_bilgileri = trim($_POST['calisan_bilgileri'] ?? '');

    try {
        $stmt = $pdo->prepare("INSERT INTO site_profil (site_id, yonetici_ad_soyad, yonetici_telefon, yonetici_mail, calisma_saatleri, iletisim_bilgileri, calisan_bilgileri)
                               VALUES (?, ?, ?, ?, ?, ?, ?)
                               ON DUPLICATE KEY UPDATE
                               yonetici_ad_soyad = VALUES(yonetici_ad_soyad),
                               yonetici_telefon = VALUES(yonetici_telefon),
                               yonetici_mail = VALUES(yonetici_mail),
                               calisma_saatleri = VALUES(calisma_saatleri),
                               iletisim_bilgileri = VALUES(iletisim_bilgileri),
                               calisan_bilgileri = VALUES(calisan_bilgileri)");
        $stmt->execute([$site_id, $yonetici_ad_soyad, $yonetici_telefon, $yonetici_mail, $calisma_saatleri, $iletisim_bilgileri, $calisan_bilgileri]);
        $basari = "Site profil bilgileri güncellendi!";
    } catch (Exception $e) {
        $hata = "Veritabanı hatası: " . $e->getMessage();
    }
}

// Bilgileri Çek
$stmt = $pdo->prepare("SELECT * FROM site_profil WHERE site_id = ?");
$stmt->execute([$site_id]);
$profil = $stmt->fetch() ?: [];
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Site Profil Bilgileri (Düzenleme)</h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php if($basari): ?><div class="alert alert-success"><?= htmlspecialchars($basari) ?></div><?php endif; ?>
    <?php if($hata): ?><div class="alert alert-danger"><?= htmlspecialchars($hata) ?></div><?php endif; ?>

    <div class="card card-primary">
      <div class="card-header"><h3 class="card-title">Site Profil Bilgilerini Düzenle</h3></div>
      <div class="card-body">
        <form method="post">
          <div class="form-group">
            <label>Yönetici Adı Soyadı</label>
            <input name="yonetici_ad_soyad" class="form-control" value="<?= htmlspecialchars($profil['yonetici_ad_soyad'] ?? '') ?>">
          </div>
          <div class="form-group">
            <label>Telefon</label>
            <input name="yonetici_telefon" class="form-control" value="<?= htmlspecialchars($profil['yonetici_telefon'] ?? '') ?>">
          </div>
          <div class="form-group">
            <label>E-posta</label>
            <input name="yonetici_mail" type="email" class="form-control" value="<?= htmlspecialchars($profil['yonetici_mail'] ?? '') ?>">
          </div>
          <div class="form-group">
            <label>Çalışma Saatleri</label>
            <textarea name="calisma_saatleri" class="form-control" rows="3"><?= htmlspecialchars($profil['calisma_saatleri'] ?? '') ?></textarea>
          </div>
          <div class="form-group">
            <label>İletişim Bilgileri (Ek Detaylar)</label>
            <textarea name="iletisim_bilgileri" class="form-control" rows="5"><?= htmlspecialchars($profil['iletisim_bilgileri'] ?? '') ?></textarea>
          </div>
          <div class="form-group">
            <label>Çalışan Bilgileri (İsim, Görev, İletişim vb.)</label>
            <textarea name="calisan_bilgileri" class="form-control" rows="10"><?= htmlspecialchars($profil['calisan_bilgileri'] ?? '') ?></textarea>
          </div>
          <div class="text-right">
            <button name="guncelle" class="btn btn-primary btn-lg">Güncelle</button>
          </div>
        </form>
      </div>
    </div>

    <!-- Önizleme -->
    <div class="card card-secondary">
      <div class="card-header"><h3 class="card-title">Üyelerin Göreceği Önizleme</h3></div>
      <div class="card-body">
        <p><strong>Yönetici Adı Soyadı:</strong> <?= htmlspecialchars($profil['yonetici_ad_soyad'] ?? '-') ?></p>
        <p><strong>Telefon:</strong> <?= htmlspecialchars($profil['yonetici_telefon'] ?? '-') ?></p>
        <p><strong>E-posta:</strong> <?= htmlspecialchars($profil['yonetici_mail'] ?? '-') ?></p>
        <p><strong>Çalışma Saatleri:</strong> <?= nl2br(htmlspecialchars($profil['calisma_saatleri'] ?? '-')) ?></p>
        <p><strong>İletişim Bilgileri:</strong> <?= nl2br(htmlspecialchars($profil['iletisim_bilgileri'] ?? '-')) ?></p>
        <p><strong>Çalışan Bilgileri:</strong> <?= nl2br(htmlspecialchars($profil['calisan_bilgileri'] ?? '-')) ?></p>
      </div>
    </div>
  </div></section>
</div>
<?php include '../inc/footer.php'; ?>