<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) {
    header('Location: login.php');
    exit;
}
$site_id = (int)$_SESSION['site_id'];
$basari = $hata = '';

// TOPLANTI EKLE
if (isset($_POST['kaydet'])) {
    $dosya1 = $dosya2 = '';
    if (!empty($_FILES['dosya1']['name'])) {
        if (!is_dir('uploads/toplanti')) mkdir('uploads/toplanti', 0755, true);
        $dosya1 = 'uploads/toplanti/' . time() . '_1_' . basename($_FILES['dosya1']['name']);
        move_uploaded_file($_FILES['dosya1']['tmp_name'], $dosya1);
    }
    if (!empty($_FILES['dosya2']['name'])) {
        $dosya2 = 'uploads/toplanti/' . time() . '_2_' . basename($_FILES['dosya2']['name']);
        move_uploaded_file($_FILES['dosya2']['tmp_name'], $dosya2);
    }
    $stmt = $pdo->prepare("INSERT INTO toplantilar (site_id, tarih, baslik, kararlar, katilanlar, dosya1, dosya2) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$site_id, $_POST['tarih'], $_POST['baslik'], $_POST['kararlar'], $_POST['katilanlar'], $dosya1, $dosya2]);
    $basari = "Toplantı eklendi!";
}

// SİLME
if (isset($_GET['sil']) && is_numeric($_GET['sil'])) {
    $sil_id = (int)$_GET['sil'];
    $stmt = $pdo->prepare("SELECT dosya1, dosya2 FROM toplantilar WHERE id = ? AND site_id = ?");
    $stmt->execute([$sil_id, $site_id]);
    $dosyalar = $stmt->fetch();
    if ($dosyalar) {
        if ($dosyalar['dosya1'] && file_exists($dosyalar['dosya1'])) unlink($dosyalar['dosya1']);
        if ($dosyalar['dosya2'] && file_exists($dosyalar['dosya2'])) unlink($dosyalar['dosya2']);
        $pdo->prepare("DELETE FROM toplantilar WHERE id = ? AND site_id = ?")->execute([$sil_id, $site_id]);
        $basari = "Toplantı silindi!";
    }
    header('Location: toplanti_salonu.php');
    exit;
}

// LİSTE
$stmt = $pdo->prepare("SELECT * FROM toplantilar WHERE site_id = ? ORDER BY tarih DESC");
$stmt->execute([$site_id]);
$toplantilar = $stmt->fetchAll();
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h1 class="m-0">Toplantı Salonu</h1>
    </div>
  </div>
  <section class="content">
    <div class="container-fluid">
      <?php if ($basari): ?>
        <div class="alert alert-success alert-dismissible">
          <button type="button" class="close" data-dismiss="alert">&times;</button>
          <?= htmlspecialchars($basari) ?>
        </div>
      <?php endif; ?>
      <!-- YENİ TOPLANTI EKLE -->
      <div class="card card-success mb-4">
        <div class="card-header collapsed" style="cursor: pointer;" data-toggle="collapse" data-target="#yeniEkleCollapse">
          <h3 class="card-title">Yeni Toplantı Ekle</h3>
          <div class="card-tools">
            <i class="fas fa-chevron-down"></i>
          </div>
        </div>
        <div id="yeniEkleCollapse" class="collapse">
          <div class="card-body">
            <form method="post" enctype="multipart/form-data">
              <div class="row">
                <div class="col-md-4">
                  <input name="tarih" type="date" class="form-control mb-2" value="<?= date('Y-m-d') ?>" required>
                </div>
                <div class="col-md-8">
                  <input name="baslik" class="form-control mb-2" placeholder="Toplantı Başlığı" required>
                </div>
                <div class="col-md-12">
                  <textarea name="kararlar" class="form-control mb-2" rows="4" placeholder="Alınan Kararlar"></textarea>
                </div>
                <div class="col-md-12">
                  <textarea name="katilanlar" class="form-control mb-2" rows="2" placeholder="Katılanlar (Ad Soyad, Ad Soyad)"></textarea>
                </div>
                <div class="col-md-6">
                  <input type="file" name="dosya1" class="form-control mb-2">
                </div>
                <div class="col-md-6">
                  <input type="file" name="dosya2" class="form-control mb-2">
                </div>
                <div class="col-md-12 text-right">
                  <button name="kaydet" class="btn btn-success btn-lg">Kaydet</button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
      <!-- TOPLANTI LİSTESİ -->
      <div class="row">
        <?php if (empty($toplantilar)): ?>
          <div class="col-12">
            <div class="alert alert-info text-center">Henüz toplantı eklenmemiş.</div>
          </div>
        <?php else: ?>
          <?php foreach ($toplantilar as $t): ?>
            <div class="col-lg-6 mb-4">
              <div class="card">
                <div class="card-header bg-success text-white collapsed" style="cursor: pointer;" data-toggle="collapse" data-target="#toplanti-<?= $t['id'] ?>">
                  <h3 class="card-title"><?= htmlspecialchars($t['baslik']) ?></h3>
                  <div class="card-tools">
                    <small><?= date('d.m.Y', strtotime($t['tarih'])) ?></small>
                    <i class="fas fa-chevron-down ml-2"></i>
                  </div>
                </div>
                <div id="toplanti-<?= $t['id'] ?>" class="collapse">
                  <div class="card-body">
                    <?php if (!empty($t['kararlar'])): ?>
                      <p><strong>Kararlar:</strong><br><?= nl2br(htmlspecialchars($t['kararlar'])) ?></p>
                    <?php endif; ?>
                    <?php if (!empty($t['katilanlar'])): ?>
                      <p><strong>Katılanlar:</strong><br><?= nl2br(htmlspecialchars($t['katilanlar'])) ?></p>
                    <?php endif; ?>
                    <?php if ($t['dosya1'] || $t['dosya2']): ?>
                      <hr>
                      <?php if ($t['dosya1']): ?>
                        <a href="<?= htmlspecialchars($t['dosya1']) ?>" target="_blank" class="btn btn-sm btn-primary mr-2">
                          <i class="fas fa-download"></i> Dosya 1
                        </a>
                      <?php endif; ?>
                      <?php if ($t['dosya2']): ?>
                        <a href="<?= htmlspecialchars($t['dosya2']) ?>" target="_blank" class="btn btn-sm btn-primary">
                          <i class="fas fa-download"></i> Dosya 2
                        </a>
                      <?php endif; ?>
                    <?php endif; ?>
                    <div class="mt-3 text-right">
                      <a href="?sil=<?= $t['id'] ?>" onclick="return confirm('Silmek istediğinize emin misiniz?');" class="btn btn-sm btn-danger">
                        <i class="fas fa-trash"></i> Sil
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
        <?php endif; ?>
      </div>
    </div>
  </section>
</div>
<script>
$('.card-header[data-toggle="collapse"]').on('click', function () {
  var icon = $(this).find('.fa-chevron-down, .fa-chevron-up');
  icon.toggleClass('fa-chevron-down fa-chevron-up');
});
</script>
<?php include '../inc/footer.php'; ?>