<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) header('Location: login.php');

$site_id = (int)$_SESSION['site_id'];
$basari = $hata = '';

// NetGSM ayarları (kendi bilgilerini yaz)
define('NETGSM_USER', '90XXXXXXXXXX');
define('NETGSM_PASS', 'SIFREN');
define('NETGSM_HEADER', 'YONETIMONLINE');

// SMS GÖNDER
if (isset($_POST['gonder'])) {
    $mesaj = trim($_POST['mesaj']);
    $stmt = $pdo->prepare("SELECT telefon FROM uyeler WHERE site_id = ? AND telefon IS NOT NULL AND telefon != ''");
    $stmt->execute([$site_id]);
    $numaralar = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (empty($numaralar)) {
        $hata = "Numara yok!";
    } else {
        $xml = '<?xml version="1.0"?>
        <mainbody>
            <header>
                <company>Netgsm</company>
                <usercode>'.NETGSM_USER.'</usercode>
                <password>'.NETGSM_PASS.'</password>
                <type>1:n</type>
                <msgheader>'.NETGSM_HEADER.'</msgheader>
            </header>
            <body>
                <msg><![CDATA['.$mesaj.']]></msg>
                <no>'.implode('</no><no>', $numaralar).'</no>
            </body>
        </mainbody>';

        $ch = curl_init('https://api.netgsm.com.tr/xmlbulkhttppost/send');
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => ['Content-Type: text/xml'],
            CURLOPT_POSTFIELDS => $xml
        ]);
        $response = curl_exec($ch);
        curl_close($ch);

        if (strpos($response, '00') === 0) {
            $basari = "SMS gönderildi! (".count($numaralar)." adet)";
        } else {
            $hata = "Hata: $response";
        }
    }
}
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>

<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>Toplu SMS</h1></div></div>
  <section class="content"><div class="container-fluid">
    <?php if($basari): ?><div class="alert alert-success"><?= $basari ?></div><?php endif; ?>
    <?php if($hata): ?><div class="alert alert-danger"><?= $hata ?></div><?php endif; ?>

    <div class="card card-success">
      <div class="card-header"><h3 class="card-title">Toplu SMS Gönder</h3></div>
      <div class="card-body">
        <form method="post">
          <textarea name="mesaj" class="form-control" rows="5" maxlength="160" placeholder="Mesajınız..." required></textarea>
          <small class="float-right"><span id="karakter">0</span>/160</small>
          <div class="text-right mt-3">
            <button name="gonder" class="btn btn-success btn-lg">GÖNDER</button>
          </div>
        </form>
      </div>
    </div>
  </div></section>
</div>

<script>
document.querySelector('textarea').addEventListener('input', function() {
  document.getElementById('karakter').textContent = this.value.length;
});
</script>

<?php include '../inc/footer.php'; ?>