<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) header('Location: login.php');

$site_id = (int)$_SESSION['site_id'];

// Filtreleme
$where = "site_id = ?";
$params = [$site_id];
if (!empty($_GET['blok'])) {
    $where .= " AND blok_adi LIKE ?";
    $params[] = '%' . $_GET['blok'] . '%';
}
if (!empty($_GET['daire'])) {
    $where .= " AND daire_no LIKE ?";
    $params[] = '%' . $_GET['daire'] . '%';
}
if (!empty($_GET['ad'])) {
    $where .= " AND ad_soyad LIKE ?";
    $params[] = '%' . $_GET['ad'] . '%';
}
if (!empty($_GET['plaka'])) {
    $where .= " AND plaka_no LIKE ?";
    $params[] = '%' . $_GET['plaka'] . '%';
}
if (isset($_GET['sahip_kiraci']) && $_GET['sahip_kiraci'] !== '') {
    $where .= " AND sahip_kiraci = ?";
    $params[] = $_GET['sahip_kiraci'];
}
if (isset($_GET['aktif']) && $_GET['aktif'] !== '') {
    $where .= " AND aktif = ?";
    $params[] = (int)$_GET['aktif'];
}

// Üyeleri çek (tüm liste, sayfa sınırlama yok)
$stmt = $pdo->prepare("SELECT * FROM uyeler WHERE $where ORDER BY blok_adi ASC, daire_no ASC");
$stmt->execute($params);
$uyeler = $stmt->fetchAll();
?>

<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>

<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <h1><i class="fas fa-users"></i> Üye Detay</h1>
    </div>
  </div>

  <section class="content">
    <div class="container-fluid">

      <!-- FİLTRE FORMU -->
      <form method="get" class="mb-4">
        <div class="row">
          <div class="col-md-2"><input name="blok" class="form-control" placeholder="Blok" value="<?= htmlspecialchars($_GET['blok'] ?? '') ?>"></div>
          <div class="col-md-2"><input name="daire" class="form-control" placeholder="Daire No" value="<?= htmlspecialchars($_GET['daire'] ?? '') ?>"></div>
          <div class="col-md-3"><input name="ad" class="form-control" placeholder="Ad Soyad" value="<?= htmlspecialchars($_GET['ad'] ?? '') ?>"></div>
          <div class="col-md-2"><input name="plaka" class="form-control" placeholder="Plaka" value="<?= htmlspecialchars($_GET['plaka'] ?? '') ?>"></div>
          <div class="col-md-2">
            <select name="sahip_kiraci" class="form-control">
              <option value="">Sahip/Kiracı</option>
              <option value="sahip" <?= ($_GET['sahip_kiraci'] ?? '') == 'sahip' ? 'selected' : '' ?>>Sahip</option>
              <option value="kiraci" <?= ($_GET['sahip_kiraci'] ?? '') == 'kiraci' ? 'selected' : '' ?>>Kiracı</option>
            </select>
          </div>
          <div class="col-md-1">
            <select name="aktif" class="form-control">
              <option value="">Durum</option>
              <option value="1" <?= ($_GET['aktif'] ?? '') == '1' ? 'selected' : '' ?>>Aktif</option>
              <option value="0" <?= ($_GET['aktif'] ?? '') == '0' ? 'selected' : '' ?>>Pasif</option>
            </select>
          </div>
          <div class="col-md-12 text-right mt-2">
            <button type="submit" class="btn btn-primary">Filtrele</button>
          </div>
        </div>
      </form>

      <div class="card">
        <div class="card-header bg-gradient-primary text-white">
          <h3 class="card-title">Üye Listesi</h3>
          <div class="card-tools">
            <div id="export_buttons" class="btn-group mr-2"></div>
          </div>
        </div>
        <div class="card-body table-responsive p-0">
          <table id="uyelerTable" class="table table-hover">
            <thead class="thead-light">
              <tr>
                <th>Blok</th>
                <th>Daire No</th>
                <th>Ad Soyad</th>
                <th>E-posta</th>
                <th>Telefon</th>
                <th>Plaka</th>
                <th>Sahip/Kiracı</th>
                <th>Durum</th>
                <th>Gözlem</th>
              </tr>
            </thead>
            <tbody>
              <?php if (empty($uyeler)): ?>
                <tr>
                  <td colspan="9" class="text-center">Hiç üye kaydı bulunmamaktadır.</td>
                </tr>
              <?php else: ?>
                <?php foreach ($uyeler as $u): ?>
                <tr>
                  <td><?= htmlspecialchars($u['blok_adi'] ?? '-') ?></td>
                  <td><?= htmlspecialchars($u['daire_no']) ?></td>
                  <td><?= htmlspecialchars($u['ad_soyad']) ?></td>
                  <td><?= htmlspecialchars($u['email']) ?></td>
                  <td><?= htmlspecialchars($u['telefon'] ?? '-') ?></td>
                  <td><?= htmlspecialchars($u['plaka_no'] ?? '-') ?></td>
                  <td><?= $u['sahip_kiraci'] === 'kiraci' ? 'Kiracı' : 'Ev Sahibi' ?></td>
                  <td><?= $u['aktif'] ? '<span class="badge badge-success">Aktif</span>' : '<span class="badge badge-danger">Pasif</span>' ?></td>
                  <td>
                    <a href="/prusaweb/panel/dashboard.php?id=<?= $u['id'] ?>" target="_blank" class="btn btn-info btn-sm">
                      <i class="fas fa-eye"></i> Gözlem
                    </a>
                  </td>
                </tr>
                <?php endforeach; ?>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>

    </div>
  </section>
</div>

<?php include '../inc/footer.php'; ?>

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap4.min.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap4.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script>
$(document).ready(function() {
    $('#uyelerTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print'],
        language: { url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/tr.json' },
        paging: false,          // sayfa değiştir butonu tamamen kaldırıldı
        searching: true,        // arama kutusu açık
        ordering: true,
        responsive: true,
        order: [[0, 'asc']],    // blok sütunu en başta sıralı
        columnDefs: [{ targets: [8], orderable: false }]
    });
});
</script>
</body>
</html>