<?php
require_once '../config/database.php';
session_start();
if (!isset($_SESSION['yonetici'])) {
    header('Location: login.php');
    exit;
}
if (!isset($_SESSION['site_id'])) {
    die("site_id bulunamadı (tenant session eksik).");
}
$site_id = (int)$_SESSION['site_id'];

/**
 * Olası telefon kolon adları listesi.
 */
$possiblePhoneCols = ['telefon', 'tel', 'telefon_no', 'gsm', 'cep_tel', 'cep', 'phone', 'mobile'];

// Tablo sütunlarını sorgula
try {
    $colsStmt = $pdo->prepare("
        SELECT COLUMN_NAME
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = DATABASE()
          AND TABLE_NAME = 'uyeler'
    ");
    $colsStmt->execute();
    $cols = $colsStmt->fetchAll(PDO::FETCH_COLUMN);
} catch (Exception $e) {
    die("Veritabanı hatası (kolon kontrolü): " . htmlspecialchars($e->getMessage()));
}

// Telefon kolonunu bul
$phoneCol = null;
foreach ($possiblePhoneCols as $c) {
    if (in_array($c, $cols, true)) {
        $phoneCol = $c;
        break;
    }
}
if ($phoneCol === null) {
    die("Telefon sütunu bulunamadı. Mevcut sütunlar: " . implode(', ', $cols));
}

// Blok ve daire sütunlarını dinamik olarak belirle
$blokCol = null;
$daireCol = null;

foreach ($cols as $col) {
    $lower = strtolower($col);
    if (in_array($lower, ['blok', 'blok_adi', 'blok_adı', 'block'])) {
        $blokCol = $col;
    }
    if (in_array($lower, ['daire', 'daire_no', 'daireno'])) {
        $daireCol = $col;
    }
}

if ($blokCol === null || $daireCol === null) {
    die("Blok veya daire sütunu bulunamadı. Mevcut sütunlar: " . implode(', ', $cols));
}

// Sorgu
try {
    $sorgu = $pdo->prepare("
        SELECT ad_soyad, {$phoneCol} as telefon, {$blokCol} as blok, {$daireCol} as daire
        FROM uyeler
        WHERE site_id = ?
          AND {$phoneCol} IS NOT NULL
          AND {$phoneCol} != ''
        ORDER BY blok ASC, daire ASC, ad_soyad ASC
    ");
    $sorgu->execute([$site_id]);
    $sakinler = $sorgu->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("Veritabanı hatası (sakinler): " . htmlspecialchars($e->getMessage()));
}
?>
<?php include '../inc/header.php'; ?>
<?php include '../inc/sidebar.php'; ?>
<?php include '../inc/navbar.php'; ?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1>WhatsApp Hızlı İletişim</h1></div></div>
  <section class="content"><div class="container-fluid">
    <div class="card">
      <div class="card-header bg-gradient-success">
        <h3 class="card-title">Sakinlerle Tek Tıkla WhatsApp</h3>
      </div>
      <div class="card-body">
        <div class="row text-center">
          <?php if (empty($sakinler)): ?>
            <div class="col-12">
              <div class="alert alert-warning">Bu siteye kayıtlı telefon bilgisi olan sakin bulunamadı.</div>
            </div>
          <?php else: ?>
            <?php foreach ($sakinler as $s):
                $raw = $s['telefon'];
                $tel = preg_replace('/[^0-9]/', '', (string)$raw);
                if (strlen($tel) === 11 && substr($tel,0,1) === '0') $tel = substr($tel,1);
                if (strlen($tel) === 10) $tel = '90'.$tel;
                if (strlen($tel) !== 12 || substr($tel,0,2) !== '90') {
                  continue;
                }
                $blokBilgisi = htmlspecialchars($s['blok'] ?? '-');
                $daireBilgisi = htmlspecialchars($s['daire'] ?? '-');
            ?>
            <div class="col-lg-3 col-md-4 col-6 mb-3">
              <a href="https://wa.me/<?= $tel ?>" target="_blank" class="btn btn-success btn-block btn-lg p-4 d-flex flex-column justify-content-center align-items-center">
                <i class="fab fa-whatsapp fa-3x mb-3"></i>
                <strong><?= htmlspecialchars($s['ad_soyad']) ?></strong>
                <small class="mt-2">Blok: <?= $blokBilgisi ?> | Daire: <?= $daireBilgisi ?></small>
              </a>
            </div>
            <?php endforeach; ?>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div></section>
</div>
<?php include '../inc/footer.php'; ?>